/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sysopen;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public final class SystemOpenAction
extends AbstractAction
implements ContextAwareAction {
    public SystemOpenAction() {
        super(NbBundle.getMessage(SystemOpenAction.class, (String)"CTL_SystemOpenAction"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        new ContextAction(Utilities.actionsGlobalContext()).actionPerformed(actionEvent);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextAction(lookup);
    }

    private static final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private static final Performer performer;
        private final Set<File> files = new HashSet<File>();

        public ContextAction(Lookup lookup) {
            super(NbBundle.getMessage(SystemOpenAction.class, (String)"CTL_SystemOpenAction"));
            for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
                File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
                if (file == null) {
                    this.files.clear();
                    break;
                }
                this.files.add(file);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (performer == null) {
                return;
            }
            for (File file : this.files) {
                try {
                    performer.open(file);
                }
                catch (IOException iOException) {
                    Logger.getLogger(SystemOpenAction.class.getName()).log(Level.INFO, null, iOException);
                }
            }
        }

        public JMenuItem getPopupPresenter() {
            class Menu
            extends JMenuItem
            implements DynamicMenuContent {
                public Menu() {
                    super(ContextAction.this);
                }

                public JComponent[] getMenuPresenters() {
                    if (performer != null && !ContextAction.this.files.isEmpty()) {
                        return new JComponent[]{this};
                    }
                    return new JComponent[0];
                }

                public JComponent[] synchMenuPresenters(JComponent[] jComponentArray) {
                    return this.getMenuPresenters();
                }
            }
            return new Menu();
        }

        static {
            Performer performer = null;
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                if (((Boolean)clazz.getMethod("isDesktopSupported", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                    final Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    Class<?> clazz2 = Class.forName("java.awt.Desktop$Action");
                    if (((Boolean)clazz.getMethod("isSupported", clazz2).invoke(object, clazz2.getField("OPEN").get(null))).booleanValue()) {
                        final Method method = clazz.getMethod("open", File.class);
                        performer = new Performer(){

                            public void open(File file) throws IOException {
                                try {
                                    method.invoke(object, file);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    throw (IOException)invocationTargetException.getTargetException();
                                }
                                catch (Exception exception) {
                                    throw (IOException)new IOException(exception.toString()).initCause(exception);
                                }
                            }
                        };
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
                Logger.getLogger(SystemOpenAction.class.getName()).log(Level.WARNING, null, exception);
            }
            ContextAction.performer = performer;
        }

        private static interface Performer {
            public void open(File var1) throws IOException;
        }
    }
}

