/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRHtmlSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_HTM = ".htm";
    private static final String EXTENSION_HTML = ".html";

    public JRHtmlSaveContributor(Locale locale, ResourceBundle resBundle) {
        super(locale, resBundle);
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName().toLowerCase();
        return name.endsWith(EXTENSION_HTM) || name.endsWith(EXTENSION_HTML);
    }

    public String getDescription() {
        return this.getBundleString("file.desc.html");
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(EXTENSION_HTM) && !file.getName().toLowerCase().endsWith(EXTENSION_HTML)) {
            file = new File(file.getAbsolutePath() + EXTENSION_HTML);
        }
        if (!file.exists() || 0 == JOptionPane.showConfirmDialog(null, MessageFormat.format(this.getBundleString("file.exists"), file.getName()), this.getBundleString("save"), 2)) {
            JRHtmlExporter exporter = new JRHtmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
            exporter.exportReport();
        }
    }
}

