/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.nativeaccess.transparency;

import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;

public class RasterRangesUtils {
    private static final int[] subColMasks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    public static boolean outputOccupiedRanges(Raster raster, RangesOutput rangesOutput) {
        Object object;
        boolean bl;
        Rectangle rectangle = raster.getBounds();
        SampleModel sampleModel = raster.getSampleModel();
        boolean bl2 = bl = sampleModel.getNumBands() == 4;
        if (raster.getParent() == null && rectangle.x == 0 && rectangle.y == 0 && ((DataBuffer)(object = raster.getDataBuffer())).getNumBanks() == 1) {
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                if (multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                    return RasterRangesUtils.outputOccupiedRangesOfBinaryPixels(((DataBufferByte)object).getData(), rectangle.width, rectangle.height, rangesOutput);
                }
            } else if (sampleModel instanceof SinglePixelPackedSampleModel && sampleModel.getDataType() == 3) {
                return RasterRangesUtils.outputOccupiedRanges(((DataBufferInt)object).getData(), rectangle.width, rectangle.height, bl ? -16777216 : 0xFFFFFF, rangesOutput);
            }
        }
        object = raster.getPixels(0, 0, rectangle.width, rectangle.height, (int[])null);
        return RasterRangesUtils.outputOccupiedRanges((int[])object, rectangle.width, rectangle.height, bl ? -16777216 : 0xFFFFFF, rangesOutput);
    }

    public static boolean outputOccupiedRangesOfBinaryPixels(byte[] byArray, int n, int n2, RangesOutput rangesOutput) {
        int n3 = byArray.length / n2;
        for (int i = 0; i < n2; ++i) {
            int n4 = i * n3;
            int n5 = -1;
            for (int j = 0; j < n3; ++j) {
                int n6 = j << 3;
                byte by = byArray[n4 + j];
                if (by == 0) {
                    if (n5 < 0) continue;
                    if (!rangesOutput.outputRange(n5, i, n6 - n5, 1)) {
                        return false;
                    }
                    n5 = -1;
                    continue;
                }
                if (by == 255) {
                    if (n5 >= 0) continue;
                    n5 = n6;
                    continue;
                }
                for (int k = 0; k < 8; ++k) {
                    int n7 = n6 | k;
                    if ((by & subColMasks[k]) != 0) {
                        if (n5 >= 0) continue;
                        n5 = n7;
                        continue;
                    }
                    if (n5 < 0) continue;
                    if (!rangesOutput.outputRange(n5, i, n7 - n5, 1)) {
                        return false;
                    }
                    n5 = -1;
                }
            }
            if (n5 < 0) continue;
            if (!rangesOutput.outputRange(n5, i, n - n5, 1)) {
                return false;
            }
            n5 = -1;
        }
        return true;
    }

    public static boolean outputOccupiedRanges(int[] nArray, int n, int n2, int n3, RangesOutput rangesOutput) {
        for (int i = 0; i < n2; ++i) {
            int n4 = i * n;
            int n5 = -1;
            for (int j = 0; j < n; ++j) {
                if ((nArray[n4 + j] & n3) != 0) {
                    if (n5 >= 0) continue;
                    n5 = j;
                    continue;
                }
                if (n5 < 0) continue;
                if (!rangesOutput.outputRange(n5, i, j - n5, 1)) {
                    return false;
                }
                n5 = -1;
            }
            if (n5 < 0) continue;
            if (!rangesOutput.outputRange(n5, i, n - n5, 1)) {
                return false;
            }
            n5 = -1;
        }
        return true;
    }

    public static interface RangesOutput {
        public boolean outputRange(int var1, int var2, int var3, int var4);
    }
}

