/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tr.extract.Param;
import tr.extract.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamFont
extends Param {
    public ParamFont(String id, String display) {
        super(Param.Type.COMBOBOX, id, display);
    }

    @Override
    public List<Param.Item> getItems() {
        if (this.items == null) {
            this.initItems();
        }
        return this.items;
    }

    private void initItems() {
        this.items = new Vector();
        this.items.add(new Param.Item("Courier", "Courier"));
        this.items.add(new Param.Item("Helvetica", "Helvetica"));
        this.items.add(new Param.Item("Times", "Times"));
        ParamFont.getFOPFonts(this.items);
    }

    private static final void getFOPFonts(List<Param.Item> items) {
        File fopConfigFile = Resources.FILE_FOP_CONFIG;
        if (fopConfigFile == null) {
            return;
        }
        Document dom = ParamFont.parseXmlFile(fopConfigFile);
        ParamFont.parseDocument(dom, items);
    }

    private static final Document parseXmlFile(File file) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(file);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void parseDocument(Document dom, List<Param.Item> items) {
        Element fop = dom.getDocumentElement();
        NodeList renderers = fop.getElementsByTagName("renderer");
        if (renderers == null) {
            return;
        }
        for (int i = 0; i < renderers.getLength(); ++i) {
            NodeList fontTriplets;
            Element renderer = (Element)renderers.item(i);
            String mime = renderer.getAttribute("mime");
            if (!mime.equalsIgnoreCase("application/pdf") || (fontTriplets = renderer.getElementsByTagName("font-triplet")) == null) continue;
            for (int j = 0; j < fontTriplets.getLength(); ++j) {
                String weight;
                Element fontTriplet = (Element)fontTriplets.item(j);
                String style = fontTriplet.getAttribute("style");
                if (!style.equalsIgnoreCase("normal") || !(weight = fontTriplet.getAttribute("weight")).equalsIgnoreCase("normal")) continue;
                String name = fontTriplet.getAttribute("name");
                items.add(new Param.Item(name, name));
            }
        }
    }
}

