/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public enum CertificateType {
    X509(0),
    OPEN_PGP(1),
    RAW_PUBLIC_KEY(2);

    private final byte value;
    private static final Map<Byte, CertificateType> MAP;

    private CertificateType(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static CertificateType getCertificateType(byte value) {
        return MAP.get(value);
    }

    public static List<CertificateType> getCertificateTypesAsList(byte[] values) {
        LinkedList<CertificateType> certificateList = new LinkedList<CertificateType>();
        for (byte b : values) {
            certificateList.add(CertificateType.getCertificateType(b));
        }
        return certificateList;
    }

    public static byte[] toByteArray(List<CertificateType> list) {
        CertificateType[] ctAsArray = new CertificateType[list.size()];
        list.toArray(ctAsArray);
        byte[] ctAsByteArray = new byte[ctAsArray.length];
        for (int i = 0; i < ctAsByteArray.length; ++i) {
            ctAsByteArray[i] = ctAsArray[i].getValue();
        }
        return ctAsByteArray;
    }

    static {
        MAP = new HashMap<Byte, CertificateType>();
        for (CertificateType c : CertificateType.values()) {
            MAP.put(c.getValue(), c);
        }
    }
}

