/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.certificate.CertificateKeyPair;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.handler.CertificateMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificateEntry;
import de.rub.nds.tlsattacker.core.protocol.message.cert.CertificatePair;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class CertificateMessage
extends HandshakeMessage {
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger requestContextLength;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.NONE)
    private ModifiableByteArray requestContext;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger certificatesListLength;
    @ModifiableVariableProperty
    private ModifiableByteArray certificatesListBytes;
    @HoldsModifiableVariable
    @XmlElementWrapper
    @XmlElement(name="certificatesList")
    private List<CertificatePair> certificatesList;
    @HoldsModifiableVariable
    private List<CertificateEntry> certificatesListAsEntry;
    @XmlTransient
    private CertificateKeyPair certificateKeyPair;

    public CertificateMessage() {
        super(HandshakeMessageType.CERTIFICATE);
    }

    public CertificateMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.CERTIFICATE);
    }

    public ModifiableInteger getCertificatesListLength() {
        return this.certificatesListLength;
    }

    public void setCertificatesListLength(ModifiableInteger certificatesListLength) {
        this.certificatesListLength = certificatesListLength;
    }

    public void setCertificatesListLength(int length) {
        this.certificatesListLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.certificatesListLength, (Integer)length);
    }

    public ModifiableByteArray getCertificatesListBytes() {
        return this.certificatesListBytes;
    }

    public void setCertificatesListBytes(ModifiableByteArray certificatesListBytes) {
        this.certificatesListBytes = certificatesListBytes;
    }

    public void setCertificatesListBytes(byte[] array) {
        this.certificatesListBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.certificatesListBytes, (byte[])array);
    }

    public List<CertificatePair> getCertificatesList() {
        return this.certificatesList;
    }

    public void setCertificatesList(List<CertificatePair> certificatesList) {
        this.certificatesList = certificatesList;
    }

    public void addCertificateList(CertificatePair CertificatePair2) {
        if (this.certificatesList == null) {
            this.certificatesList = new LinkedList<CertificatePair>();
        }
        this.certificatesList.add(CertificatePair2);
    }

    public List<CertificateEntry> getCertificatesListAsEntry() {
        return this.certificatesListAsEntry;
    }

    public void setCertificatesListAsEntry(List<CertificateEntry> certificatesListAsEntry) {
        this.certificatesListAsEntry = certificatesListAsEntry;
    }

    public void addCertificateList(CertificateEntry certificateEntry) {
        if (this.certificatesListAsEntry == null) {
            this.certificatesListAsEntry = new LinkedList<CertificateEntry>();
        }
        this.certificatesListAsEntry.add(certificateEntry);
    }

    public ModifiableInteger getRequestContextLength() {
        return this.requestContextLength;
    }

    public void setRequestContextLength(ModifiableInteger requestContextLength) {
        this.requestContextLength = requestContextLength;
    }

    public void setRequestContextLength(int length) {
        this.requestContextLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.requestContextLength, (Integer)length);
    }

    public ModifiableByteArray getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(ModifiableByteArray requestContext) {
        this.requestContext = requestContext;
    }

    public void setRequestContext(byte[] array) {
        this.requestContext = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.requestContext, (byte[])array);
    }

    public boolean hasRequestContext() {
        return (Integer)this.requestContextLength.getValue() > 0;
    }

    public CertificateKeyPair getCertificateKeyPair() {
        return this.certificateKeyPair;
    }

    public void setCertificateKeyPair(CertificateKeyPair certificateKeyPair) {
        this.certificateKeyPair = certificateKeyPair;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CertificateMessage:");
        sb.append("\n  Certificates Length: ");
        if (this.certificatesListLength != null && this.certificatesListLength.getValue() != null) {
            sb.append(this.certificatesListLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  Certificate:\n");
        if (this.certificatesListBytes != null && this.certificatesListBytes.getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.certificatesListBytes.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new CertificateMessageHandler(context);
    }
}

