/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HelloMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.HandshakeMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class HelloMessageSerializer<T extends HelloMessage>
extends HandshakeMessageSerializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final T msg;

    public HelloMessageSerializer(T message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    protected void writeProtocolVersion() {
        this.appendBytes((byte[])((HelloMessage)this.msg).getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])((HelloMessage)this.msg).getProtocolVersion().getValue())));
    }

    protected void writeRandom() {
        this.appendBytes((byte[])((HelloMessage)this.msg).getRandom().getValue());
        LOGGER.debug("Random: " + ArrayConverter.bytesToHexString((byte[])((byte[])((HelloMessage)this.msg).getRandom().getValue())));
    }

    protected void writeSessionIDLength() {
        this.appendInt((Integer)((HelloMessage)this.msg).getSessionIdLength().getValue(), 1);
        LOGGER.debug("SessionIDLength: " + ((HelloMessage)this.msg).getSessionIdLength().getValue());
    }

    protected void writeSessionID() {
        this.appendBytes((byte[])((HelloMessage)this.msg).getSessionId().getValue());
        LOGGER.debug("SessionID: " + ArrayConverter.bytesToHexString((byte[])((byte[])((HelloMessage)this.msg).getSessionId().getValue())));
    }
}

