/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.state;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.state.ContextContainer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceNormalizer;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceSerializer;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.filter.Filter;
import de.rub.nds.tlsattacker.core.workflow.filter.FilterFactory;
import de.rub.nds.tlsattacker.core.workflow.filter.FilterType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class State {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ContextContainer contextContainer = new ContextContainer();
    private Config config = null;
    private RunningModeType runningMode = null;
    @HoldsModifiableVariable
    private final WorkflowTrace workflowTrace;
    private WorkflowTrace originalWorkflowTrace;

    public State() {
        this(Config.createConfig());
    }

    public State(WorkflowTrace trace) {
        this(Config.createConfig(), trace);
    }

    public State(Config config) {
        this.config = config;
        this.runningMode = config.getDefaultRunningMode();
        this.workflowTrace = this.loadWorkflowTrace();
        this.initState();
    }

    public State(Config config, WorkflowTrace workflowTrace) {
        this.config = config;
        this.runningMode = config.getDefaultRunningMode();
        this.workflowTrace = workflowTrace;
        this.initState();
    }

    public void reset() {
        this.contextContainer.clear();
        this.workflowTrace.reset();
        this.initState();
    }

    public final void initState() {
        if (this.config.isFiltersKeepUserSettings().booleanValue()) {
            this.originalWorkflowTrace = WorkflowTrace.copy(this.workflowTrace);
        }
        WorkflowTraceNormalizer normalizer = new WorkflowTraceNormalizer();
        normalizer.normalize(this.workflowTrace, this.config, this.runningMode);
        this.workflowTrace.setDirty(false);
        for (AliasedConnection con : this.workflowTrace.getConnections()) {
            TlsContext ctx = new TlsContext(this.config, con);
            this.addTlsContext(ctx);
        }
    }

    private WorkflowTrace loadWorkflowTrace() {
        WorkflowTrace trace = null;
        if (this.config.getWorkflowInput() != null) {
            try {
                trace = WorkflowTraceSerializer.read(new FileInputStream(new File(this.config.getWorkflowInput())));
                LOGGER.debug("Loaded workflow trace from " + this.config.getWorkflowInput());
            }
            catch (FileNotFoundException ex) {
                LOGGER.warn("Could not read workflow trace. File not found: " + this.config.getWorkflowInput());
                LOGGER.debug((Object)ex);
            }
            catch (IOException | JAXBException | XMLStreamException ex) {
                LOGGER.warn("Could not read workflow trace: " + this.config.getWorkflowInput());
                LOGGER.debug((Object)ex);
            }
        } else if (this.config.getWorkflowTraceType() != null) {
            WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
            trace = factory.createWorkflowTrace(this.config.getWorkflowTraceType(), this.runningMode);
            LOGGER.debug("Created new " + (Object)((Object)this.config.getWorkflowTraceType()) + " workflow trace");
        }
        if (trace == null) {
            throw new ConfigurationException("Could not load workflow trace");
        }
        return trace;
    }

    public Config getConfig() {
        return this.config;
    }

    public WorkflowTrace getWorkflowTrace() {
        return this.workflowTrace;
    }

    public WorkflowTrace getOriginalWorkflowTrace() {
        return this.originalWorkflowTrace;
    }

    public void replaceTlsContext(TlsContext newTlsContext) {
        this.contextContainer.replaceTlsContext(newTlsContext);
    }

    public TlsContext getTlsContext() {
        return this.contextContainer.getTlsContext();
    }

    public TlsContext getTlsContext(String alias) {
        return this.contextContainer.getTlsContext(alias);
    }

    public List<TlsContext> getAllTlsContexts() {
        return this.contextContainer.getAllContexts();
    }

    public List<TlsContext> getInboundTlsContexts() {
        return this.contextContainer.getInboundTlsContexts();
    }

    public List<TlsContext> getOutboundTlsContexts() {
        return this.contextContainer.getOutboundTlsContexts();
    }

    public RunningModeType getRunningMode() {
        return this.runningMode;
    }

    public void setRunningMode(RunningModeType runningMode) {
        this.runningMode = runningMode;
    }

    private void addTlsContext(TlsContext context) {
        this.contextContainer.addTlsContext(context);
    }

    public WorkflowTrace getWorkflowTraceCopy() {
        return WorkflowTrace.copy(this.workflowTrace);
    }

    public WorkflowTrace getFilteredTraceCopy() {
        return this.getFilteredTraceCopy(this.workflowTrace);
    }

    private WorkflowTrace getFilteredTraceCopy(WorkflowTrace trace) {
        WorkflowTrace filtered = WorkflowTrace.copy(trace);
        this.filterTrace(filtered);
        return filtered;
    }

    private void filterTrace(WorkflowTrace trace) {
        List<FilterType> filters = this.config.getOutputFilters();
        if (filters == null || filters.isEmpty()) {
            LOGGER.debug("No filters to apply, ouput filter list is empty");
            return;
        }
        if (filters.contains(null)) {
            LOGGER.debug("No filters to apply");
            return;
        }
        for (FilterType filterType : this.config.getOutputFilters()) {
            Filter filter = FilterFactory.createWorkflowTraceFilter(filterType, this.config);
            filter.applyFilter(trace);
            if (!this.config.isFiltersKeepUserSettings().booleanValue()) continue;
            filter.postFilter(trace, this.originalWorkflowTrace);
        }
    }

    public void storeTrace() {
        this.assertWorkflowTraceNotNull("storeTrace");
        Random random = new Random();
        if (this.config.getWorkflowOutput() != null && !this.config.getWorkflowOutput().isEmpty()) {
            try {
                WorkflowTrace filteredTrace;
                File f = new File(this.config.getWorkflowOutput());
                if (f.isDirectory()) {
                    f = new File(this.config.getWorkflowOutput() + "trace-" + random.nextInt());
                }
                if (this.config.isApplyFiltersInPlace().booleanValue()) {
                    filteredTrace = this.workflowTrace;
                    this.filterTrace(filteredTrace);
                } else {
                    filteredTrace = this.getFilteredTraceCopy(this.workflowTrace);
                }
                WorkflowTraceSerializer.write(f, filteredTrace);
            }
            catch (IOException | JAXBException ex) {
                LOGGER.info("Could not serialize WorkflowTrace.");
                LOGGER.debug((Object)ex);
            }
        }
    }

    private void assertWorkflowTraceNotNull(String operation_name) {
        if (this.workflowTrace != null) {
            return;
        }
        StringBuilder err = new StringBuilder("No workflow trace loaded.");
        if (operation_name != null && !operation_name.isEmpty()) {
            err.append(" Operation ").append(operation_name).append(" not permitted");
        }
        throw new ConfigurationException(err.toString());
    }
}

