/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.lang.ref.Reference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.search.CleanTask;
import org.netbeans.modules.search.PrintDetailsTask;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultDisplayer;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchDisplayer;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.spi.search.provider.SearchComposition;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.OutputWriter;

public final class Manager {
    static final int SEARCHING = 1;
    static final int REPLACING = 8;
    static final int EVENT_SEARCH_STARTED = 1;
    static final int EVENT_SEARCH_FINISHED = 2;
    static final int EVENT_SEARCH_INTERRUPTED = 3;
    static final int EVENT_SEARCH_CANCELLED = 4;
    private static final Manager instance = new Manager();
    private final List<Runnable> pendingTasks = new LinkedList<Runnable>();
    private TaskListener taskListener;
    private final List<Runnable> currentTasks = new LinkedList<Runnable>();
    private final List<Runnable> stoppingTasks = new LinkedList<Runnable>();
    private boolean searchWindowOpen = false;
    private Reference<OutputWriter> outputWriterRef;
    private Map<Task, Runnable> tasksMap = new HashMap<Task, Runnable>();
    private static final RequestProcessor RP = new RequestProcessor(Manager.class.getName());

    public static Manager getInstance() {
        return instance;
    }

    private Manager() {
    }

    synchronized void scheduleSearchTask(SearchTask searchTask) {
        assert (EventQueue.isDispatchThread());
        ResultView resultView = ResultView.getInstance();
        resultView.open();
        resultView.requestActive();
        searchTask.setResultViewPanel(resultView.addTab(searchTask));
        this.pendingTasks.add(searchTask);
        this.processNextPendingTask();
    }

    public <R> void scheduleSearchTask(SearchComposition<R> searchComposition, boolean bl) {
        this.scheduleSearchTask(new SearchTask(searchComposition, bl));
    }

    public synchronized void scheduleReplaceTask(ReplaceTask replaceTask) {
        assert (EventQueue.isDispatchThread());
        this.pendingTasks.add(replaceTask);
        this.processNextPendingTask();
    }

    public synchronized void schedulePrintTask(PrintDetailsTask printDetailsTask) {
        assert (EventQueue.isDispatchThread());
        this.pendingTasks.add(printDetailsTask);
        this.processNextPendingTask();
    }

    synchronized void scheduleCleanTask(CleanTask cleanTask) {
        assert (EventQueue.isDispatchThread());
        this.pendingTasks.add(cleanTask);
        this.processNextPendingTask();
    }

    synchronized String mayStartSearching() {
        String string = this.haveRunningReplaceTask() ? "MSG_Cannot_start_search__replacing" : null;
        return string != null ? NbBundle.getMessage(this.getClass(), (String)string) : null;
    }

    private void notifySearchStarted(SearchTask searchTask) {
        this.notifySearchTaskStateChange(searchTask, 1);
    }

    private void notifySearchFinished(SearchTask searchTask) {
        this.notifySearchTaskStateChange(searchTask, 2);
    }

    private void notifySearchInterrupted(SearchTask searchTask) {
        this.notifySearchTaskStateChange(searchTask, 3);
    }

    private void notifySearchCancelled(SearchTask searchTask) {
        this.notifySearchTaskStateChange(searchTask, 4);
    }

    private void notifySearchTaskStateChange(SearchTask searchTask, int n) {
        Method method;
        try {
            method = ResultView.class.getDeclaredMethod("searchTaskStateChanged", SearchTask.class, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        this.callOnWindowFromAWT(method, new Object[]{searchTask, n});
    }

    private void notifySearchPending(SearchTask searchTask, int n) {
        Method method;
        if (!this.searchWindowOpen) {
            return;
        }
        try {
            method = ResultView.class.getDeclaredMethod("notifySearchPending", SearchTask.class, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        this.callOnWindowFromAWT(method, new Object[]{searchTask, n});
    }

    private void notifyReplaceFinished(ReplaceTask replaceTask) {
        ReplaceTask.ResultStatus resultStatus = replaceTask.getResultStatus();
        if (resultStatus == ReplaceTask.ResultStatus.SUCCESS) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(this.getClass(), (String)"MSG_Success"));
            if (this.searchWindowOpen) {
                replaceTask.getPanel().showFinishedInfo();
            }
        } else {
            String string = resultStatus == ReplaceTask.ResultStatus.PRE_CHECK_FAILED ? "MSG_Issues_found_during_precheck" : "MSG_Issues_found_during_replace";
            String string2 = NbBundle.getMessage(this.getClass(), (String)string);
            replaceTask.getPanel().displayIssuesToUser(replaceTask, string2, replaceTask.getProblems(), resultStatus != ReplaceTask.ResultStatus.PRE_CHECK_FAILED);
            if (resultStatus == ReplaceTask.ResultStatus.PRE_CHECK_FAILED) {
                this.offerRescanAfterIssuesFound(replaceTask);
            }
        }
    }

    private void offerRescanAfterIssuesFound(ReplaceTask replaceTask) {
        String string = NbBundle.getMessage(this.getClass(), (String)"MSG_IssuesFound_Rescan_");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 3);
        String string2 = NbBundle.getMessage(this.getClass(), (String)"LBL_Rerun");
        message.setOptions(new Object[]{string2, NotifyDescriptor.CANCEL_OPTION});
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        if (string2.equals(object)) {
            Mutex.EVENT.writeAccess(replaceTask.getPanel()::rescan);
        }
    }

    private void notifyPrintingDetailsFinished() {
        if (!this.searchWindowOpen) {
            return;
        }
        this.callOnWindowFromAWT("showAllDetailsFinished");
    }

    private void activateResultWindow() {
        Method method;
        try {
            method = ResultView.class.getMethod("requestActive", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(method, null);
    }

    private void displayIssuesFromAWT(ReplaceTask replaceTask, String string, boolean bl) {
        Method method;
        try {
            method = ResultView.class.getDeclaredMethod("displayIssuesToUser", ReplaceTask.class, String.class, String[].class, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        this.callOnWindowFromAWT(method, new Object[]{replaceTask, string, replaceTask.getProblems(), bl}, false);
    }

    private void callOnWindowFromAWT(String string) {
        this.callOnWindowFromAWT(string, true);
    }

    private void callOnWindowFromAWT(String string, boolean bl) {
        Method method;
        try {
            method = ResultView.class.getDeclaredMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
        this.callOnWindowFromAWT(method, null, bl);
    }

    private void callOnWindowFromAWT(Method method, Object[] objectArray) {
        this.callOnWindowFromAWT(method, objectArray, true);
    }

    private void callOnWindowFromAWT(Method method, Object[] objectArray, boolean bl) {
        Runnable runnable = () -> {
            ResultView resultView = ResultView.getInstance();
            try {
                method.invoke((Object)resultView, objectArray);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else if (bl) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    synchronized void searchWindowOpened() {
        this.searchWindowOpen = true;
    }

    synchronized void searchWindowClosed() {
        Runnable[] runnableArray;
        assert (EventQueue.isDispatchThread());
        this.searchWindowOpen = false;
        for (Runnable runnable : runnableArray = this.currentTasks.toArray(new Runnable[0])) {
            if (!(runnable instanceof SearchTask)) continue;
            SearchTask searchTask = (SearchTask)runnable;
            searchTask.stop(true);
            if (!(searchTask.getDisplayer() instanceof ResultDisplayer)) continue;
            ResultDisplayer resultDisplayer = (ResultDisplayer)searchTask.getDisplayer();
            this.scheduleCleanTask(new CleanTask(resultDisplayer.getResultModel()));
        }
    }

    private synchronized void processNextPendingTask() {
        Runnable[] runnableArray;
        for (Runnable runnable : runnableArray = this.pendingTasks.toArray(new Runnable[0])) {
            boolean bl = this.haveRunningReplaceTask();
            if (runnable instanceof SearchTask) {
                if (!this.stoppingTasks.isEmpty()) {
                    this.notifySearchPending((SearchTask)runnable, 1);
                    continue;
                }
                if (bl) {
                    this.notifySearchPending((SearchTask)runnable, 8);
                    continue;
                }
                if (!this.pendingTasks.remove(runnable)) continue;
                this.startSearching((SearchTask)runnable);
                continue;
            }
            if (runnable instanceof ReplaceTask) {
                if (bl || this.haveRunningSearchTask() || !this.pendingTasks.remove(runnable)) continue;
                this.startReplacing((ReplaceTask)runnable);
                continue;
            }
            if (runnable instanceof PrintDetailsTask) {
                if (!this.pendingTasks.remove(runnable)) continue;
                this.startPrintingDetails((PrintDetailsTask)runnable);
                continue;
            }
            if (runnable instanceof CleanTask) {
                if (!this.pendingTasks.remove(runnable)) continue;
                this.startCleaning((CleanTask)runnable);
                continue;
            }
            assert (false) : "Unexpected task: " + runnable;
        }
    }

    private boolean haveRunningReplaceTask() {
        for (Runnable runnable : this.currentTasks) {
            if (!(runnable instanceof ReplaceTask)) continue;
            return true;
        }
        return false;
    }

    private boolean haveRunningSearchTask() {
        for (Runnable runnable : this.currentTasks) {
            if (!(runnable instanceof SearchTask)) continue;
            return true;
        }
        return false;
    }

    private void startSearching(SearchTask searchTask) {
        this.notifySearchStarted(searchTask);
        if (this.outputWriterRef != null) {
            SearchDisplayer.clearOldOutput(this.outputWriterRef);
            this.outputWriterRef = null;
            this.activateResultWindow();
        }
        this.runTask(searchTask);
    }

    private void startReplacing(ReplaceTask replaceTask) {
        this.runTask(replaceTask);
    }

    private void startPrintingDetails(PrintDetailsTask printDetailsTask) {
        if (this.outputWriterRef != null) {
            SearchDisplayer.clearOldOutput(this.outputWriterRef);
            this.outputWriterRef = null;
        }
        this.runTask(printDetailsTask);
    }

    private void startCleaning(CleanTask cleanTask) {
        this.runTask(cleanTask);
    }

    private void runTask(Runnable runnable) {
        assert (runnable != null);
        this.currentTasks.add(runnable);
        RequestProcessor.Task task = RP.create(runnable);
        this.tasksMap.put((Task)task, runnable);
        task.addTaskListener(this.getTaskListener());
        task.schedule(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopSearching(SearchTask searchTask) {
        boolean bl = false;
        Manager manager = this;
        synchronized (manager) {
            if (this.pendingTasks.remove(searchTask)) {
                this.notifySearchCancelled(searchTask);
            } else if (this.currentTasks.contains(searchTask) && !this.stoppingTasks.contains(searchTask)) {
                this.stoppingTasks.add(searchTask);
                bl = true;
            }
        }
        if (bl) {
            searchTask.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskFinished(Runnable runnable) {
        this.notifyTaskFinished(runnable);
        Manager manager = this;
        synchronized (manager) {
            if (runnable instanceof SearchTask) {
                this.stoppingTasks.remove(runnable);
            } else if (runnable instanceof PrintDetailsTask) {
                PrintDetailsTask printDetailsTask = (PrintDetailsTask)runnable;
                this.outputWriterRef = printDetailsTask.getOutputWriterRef();
            }
            this.currentTasks.remove(runnable);
        }
        this.processNextPendingTask();
    }

    private void notifyTaskFinished(Runnable runnable) {
        if (runnable instanceof SearchTask) {
            SearchTask searchTask = (SearchTask)runnable;
            if (searchTask.notifyWhenFinished()) {
                if (searchTask.wasInterrupted()) {
                    this.notifySearchInterrupted(searchTask);
                } else {
                    this.notifySearchFinished(searchTask);
                }
            }
        } else if (runnable instanceof ReplaceTask) {
            ReplaceTask replaceTask = (ReplaceTask)runnable;
            this.notifyReplaceFinished(replaceTask);
        } else if (runnable instanceof PrintDetailsTask) {
            PrintDetailsTask printDetailsTask = (PrintDetailsTask)runnable;
            this.notifyPrintingDetailsFinished();
        }
    }

    private TaskListener getTaskListener() {
        if (this.taskListener == null) {
            this.taskListener = new MyTaskListener();
        }
        return this.taskListener;
    }

    private class MyTaskListener
    implements TaskListener {
        MyTaskListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskFinished(Task task) {
            Runnable runnable;
            Manager manager = Manager.this;
            synchronized (manager) {
                runnable = (Runnable)Manager.this.tasksMap.remove(task);
            }
            if (runnable != null) {
                Manager.this.taskFinished(runnable);
            }
        }
    }
}

