/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.graalvm.visualvm.lib.ui.Formatters;

public class RubyDetailsProvider
extends DetailsProvider.Basic {
    private static final String RUBY_OBJECT_TYPE_MASK = "org.truffleruby.language.RubyObjectType+";
    private static final String ASCII_ROPE_MASK = "org.truffleruby.core.rope.AsciiOnlyLeafRope";
    private static final String CONCAT_ROPE_MASK = "org.truffleruby.core.rope.ConcatRope";
    private static final String SUB_ROPE_MASK = "org.truffleruby.core.rope.SubstringRope";
    private static final String INVALID_ROPE_MASK = "org.truffleruby.core.rope.InvalidLeafRope";
    private static final String VALID_ROPE_MASK = "org.truffleruby.core.rope.ValidLeafRope";
    private static final String INT_ROPE_MASK = "org.truffleruby.core.rope.LazyIntRope";
    private static final String ROPE_TABLE_KEY_MASK = "org.truffleruby.core.rope.RopeTable$Key";
    private static final String ENCODING_MASK = "org.jcodings.Encoding+";
    private static final String MODULE_FIELDS_MASK = "org.truffleruby.core.module.ModuleFields";
    private static final String BASIC_LAYOUT_MASK = "org.truffleruby.core.basicobject.BasicObjectLayoutImpl$BasicObjectType+";
    private static final String METHOD_INFO_MASK = "org.truffleruby.language.methods.SharedMethodInfo";
    private static final String RUBY_ROOT_NODE_MASK = "org.truffleruby.language.RubyRootNode";
    private static final String RUBY_MODULE_MASK = "org.truffleruby.core.module.RubyModule+";
    private static final String RUBY_PROC_MASK = "org.truffleruby.core.proc.RubyProc";
    private static final String RUBY_STRING_MASK = "org.truffleruby.core.string.RubyString";
    private static final String RUBY_ISTRING_MASK = "org.truffleruby.core.string.ImmutableRubyString";
    private static final String RUBY_ARRAY_MASK = "org.truffleruby.core.array.RubyArray";
    private static final String RUBY_SYMBOL_MASK = "org.truffleruby.core.symbol.RubySymbol";
    private static final String RUBY_HASH_MASK = "org.truffleruby.core.hash.RubyHash";
    private static final String RUBY_ENCODING_MASK = "org.truffleruby.core.encoding.RubyEncoding";
    private static final String RUBY_REGEXP_MASK = "org.truffleruby.core.regexp.RubyRegexp";

    public RubyDetailsProvider() {
        super(new String[]{RUBY_OBJECT_TYPE_MASK, ASCII_ROPE_MASK, CONCAT_ROPE_MASK, SUB_ROPE_MASK, ROPE_TABLE_KEY_MASK, INVALID_ROPE_MASK, VALID_ROPE_MASK, INT_ROPE_MASK, ENCODING_MASK, MODULE_FIELDS_MASK, BASIC_LAYOUT_MASK, METHOD_INFO_MASK, RUBY_ROOT_NODE_MASK, RUBY_MODULE_MASK, RUBY_PROC_MASK, RUBY_STRING_MASK, RUBY_ISTRING_MASK, RUBY_ARRAY_MASK, RUBY_SYMBOL_MASK, RUBY_HASH_MASK, RUBY_ENCODING_MASK, RUBY_REGEXP_MASK});
    }

    public String getDetailsString(String className, Instance instance) {
        switch (className) {
            case "org.truffleruby.language.RubyObjectType+": {
                String name = instance.getJavaClass().getName();
                int index = name.lastIndexOf(36);
                if (index == -1) {
                    index = name.lastIndexOf(46);
                }
                return name.substring(index + 1);
            }
            case "org.truffleruby.core.rope.AsciiOnlyLeafRope": {
                Integer len = (Integer)instance.getValueOfField("byteLength");
                return this.getByteArrayFieldString(instance, "bytes", 0, len, "...");
            }
            case "org.truffleruby.core.rope.ConcatRope": {
                Object vall = instance.getValueOfField("left");
                Object valr = instance.getValueOfField("right");
                if (vall == null && valr == null) {
                    Integer len = (Integer)instance.getValueOfField("byteLength");
                    return this.getByteArrayFieldString(instance, "bytes", 0, len, "...");
                }
                String left = DetailsUtils.getInstanceString((Instance)((Instance)vall));
                if (left == null) {
                    return DetailsUtils.getInstanceString((Instance)((Instance)valr));
                }
                if (valr == null || left.length() > 160) {
                    return left;
                }
                String value = left + DetailsUtils.getInstanceString((Instance)((Instance)valr));
                if (value.length() > 160) {
                    return value.substring(0, 160) + "...";
                }
                return value;
            }
            case "org.truffleruby.core.rope.SubstringRope": {
                Object offset = instance.getValueOfField("byteOffset");
                Object child = instance.getValueOfField("child");
                String childString = DetailsUtils.getInstanceString((Instance)((Instance)child));
                if (offset == null) {
                    offset = instance.getValueOfField("offset");
                }
                int byteOffset = (Integer)offset;
                Object length = instance.getValueOfField("byteLength");
                int byteLength = (Integer)length;
                if (childString.length() <= byteOffset || childString.length() < byteOffset + byteLength) break;
                return childString.substring(byteOffset, byteOffset + byteLength);
            }
            case "org.jcodings.Encoding+": {
                return this.getByteArrayFieldString(instance, "name", 0, -1, "...");
            }
            case "org.truffleruby.core.rope.RopeTable$Key": {
                byte[] bytes = this.getByteArrayFieldString(instance, "bytes", 0, -1);
                String encodingString = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"encoding");
                return this.getString(bytes, encodingString, "...");
            }
            case "org.truffleruby.core.rope.InvalidLeafRope": {
                byte[] bytes = this.getByteArrayFieldString(instance, "bytes", 0, -1);
                String encodingString = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"encoding");
                return this.getString(bytes, encodingString, "...");
            }
            case "org.truffleruby.core.rope.ValidLeafRope": {
                byte[] bytes = this.getByteArrayFieldString(instance, "bytes", 0, -1);
                String encodingString = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"encoding");
                return this.getString(bytes, encodingString, "...");
            }
            case "org.truffleruby.core.rope.LazyIntRope": {
                return Integer.toString(DetailsUtils.getIntFieldValue((Instance)instance, (String)"value", (int)0));
            }
            case "org.truffleruby.core.module.ModuleFields": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
            case "org.truffleruby.core.basicobject.BasicObjectLayoutImpl$BasicObjectType+": {
                Instance logicalClassInst = (Instance)instance.getValueOfField("logicalClass");
                if (!DynamicObject.isDynamicObject(logicalClassInst)) break;
                DynamicObject logicalClass = new DynamicObject(logicalClassInst);
                ObjectFieldValue fields = (ObjectFieldValue)logicalClass.getFieldValue("fields (hidden)");
                return DetailsUtils.getInstanceString((Instance)fields.getInstance());
            }
            case "org.truffleruby.language.methods.SharedMethodInfo": {
                Instance name = (Instance)instance.getValueOfField("name");
                if (name == null) {
                    name = (Instance)instance.getValueOfField("notes");
                }
                return DetailsUtils.getInstanceString((Instance)name);
            }
            case "org.truffleruby.language.RubyRootNode": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"sharedMethodInfo");
            }
            case "org.truffleruby.core.module.RubyModule+": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"fields");
            }
            case "org.truffleruby.core.proc.RubyProc": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"sharedMethodInfo");
            }
            case "org.truffleruby.core.string.ImmutableRubyString": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"tstring");
            }
            case "org.truffleruby.core.string.RubyString": {
                String s = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"tstring");
                if (s == null) {
                    s = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"rope");
                }
                return s;
            }
            case "org.truffleruby.core.array.RubyArray": 
            case "org.truffleruby.core.hash.RubyHash": {
                Integer length = (Integer)instance.getValueOfField("size");
                if (length == null) break;
                return Formatters.numberFormat().format(length) + (length == 1 ? " item" : " items");
            }
            case "org.truffleruby.core.symbol.RubySymbol": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"string");
            }
            case "org.truffleruby.core.encoding.RubyEncoding": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            }
            case "org.truffleruby.core.regexp.RubyRegexp": {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"source");
            }
        }
        return null;
    }

    private byte[] getByteArrayFieldString(Instance instance, String field, int offset, int count) {
        PrimitiveArrayInstance array;
        List values;
        Object fieldVal = instance.getValueOfField(field);
        if (fieldVal instanceof PrimitiveArrayInstance && (values = (array = (PrimitiveArrayInstance)fieldVal).getValues()) != null) {
            int valuesCount = count < 0 ? values.size() - offset : Math.min(count, values.size() - offset);
            int estimatedSize = Math.min(valuesCount, 161);
            byte[] bytes = new byte[estimatedSize];
            int lastValue = offset + valuesCount - 1;
            for (int i = offset; i <= lastValue; ++i) {
                bytes[i - offset] = Byte.parseByte((String)values.get(i));
                if (i - offset + 1 >= 160) break;
            }
            return bytes;
        }
        return null;
    }

    private String getByteArrayFieldString(Instance instance, String field, int offset, int count, String trailer) {
        byte[] bytes = this.getByteArrayFieldString(instance, field, offset, count);
        return this.getString(bytes, Charset.defaultCharset().name(), trailer);
    }

    private String getString(byte[] bytes, String encodingString, String trailer) {
        if (bytes != null) {
            String val;
            int len = Math.min(bytes.length, 160);
            try {
                val = new String(bytes, 0, len, encodingString);
            }
            catch (UnsupportedEncodingException ex) {
                val = new String(bytes, 0, len);
            }
            if (bytes.length > 160) {
                return val + trailer;
            }
            return val;
        }
        return null;
    }
}

