/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server;

import org.graalvm.visualvm.lib.jfluid.server.ProfilerInterface;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntime;
import org.graalvm.visualvm.lib.jfluid.server.ProfilerRuntimeCPU;
import org.graalvm.visualvm.lib.jfluid.server.ProfilingPointServerHandler;
import org.graalvm.visualvm.lib.jfluid.server.system.GC;

public class TakeSnapshotProfilingPointHandler
extends ProfilingPointServerHandler {
    private static ProfilingPointServerHandler instance;

    public static synchronized ProfilingPointServerHandler getInstance(String clientInfo) {
        if (instance == null) {
            instance = new TakeSnapshotProfilingPointHandler();
        }
        return instance;
    }

    public void profilingPointHit(int id) {
        boolean cpuProfiling;
        int instrType = ProfilerInterface.getCurrentInstrType();
        boolean bl = cpuProfiling = instrType == 3 || instrType == 4;
        if (cpuProfiling) {
            ProfilerRuntimeCPU.suspendCurrentThreadTimer();
        } else {
            GC.runGC();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.profilingPointHit(id);
        ProfilerRuntime.dumpEventBuffer();
        if (cpuProfiling) {
            ProfilerRuntimeCPU.resumeCurrentThreadTimer();
        }
    }
}

