/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.util.MCPackage;

public class MCType
implements IMCType {
    static final IMCType UNKNOWN = new MCType("");
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private final String fullName;
    private final String typeName;
    private final IMCPackage _package;

    MCType(String jlsTypeName) {
        String packageName;
        this.fullName = jlsTypeName;
        int point = MCType.findPackageNameLength(jlsTypeName);
        if (point >= 0) {
            packageName = jlsTypeName.substring(0, point);
            this.typeName = jlsTypeName.substring(point + 1);
        } else {
            packageName = "";
            this.typeName = jlsTypeName;
        }
        this._package = new MCPackage(packageName, null, null);
    }

    private static int findPackageNameLength(String jlsTypeName) {
        int point = -1;
        block4: for (int i = 0; i < jlsTypeName.length(); ++i) {
            switch (jlsTypeName.charAt(i)) {
                case '.': {
                    point = i;
                    continue block4;
                }
                case '$': {
                    return point;
                }
            }
        }
        return point;
    }

    @Override
    public IMCPackage getPackage() {
        return this._package;
    }

    @Override
    public final String getTypeName() {
        return this.typeName;
    }

    @Override
    public final String getFullName() {
        return this.fullName;
    }

    public String toString() {
        return this.fullName;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof MCType && ((MCType)obj).fullName.equals(this.fullName);
    }
}

