/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.mac;

import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.impl.KeyringSupport;
import org.netbeans.modules.keyring.mac.SecurityLibrary;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.Utilities;

public class MacProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(MacProvider.class.getName());
    private final byte[] appName = KeyringSupport.getAppNameMac().getBytes(StandardCharsets.UTF_8);

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            LOG.fine("native keyring integration disabled");
            return false;
        }
        return Utilities.isMac();
    }

    public char[] read(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = this.appName;
        int[] nArray = new int[1];
        Pointer[] pointerArray = new Pointer[1];
        MacProvider.error("find", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, byArray.length, byArray, byArray2.length, byArray2, nArray, pointerArray, null));
        if (pointerArray[0] == null) {
            return null;
        }
        byte[] byArray3 = pointerArray[0].getByteArray(0L, nArray[0]);
        return new String(byArray3, StandardCharsets.UTF_8).toCharArray();
    }

    public void save(String string, char[] cArray, String string2) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = this.appName;
        byte[] byArray3 = new String(cArray).getBytes(StandardCharsets.UTF_8);
        Pointer[] pointerArray = new Pointer[1];
        MacProvider.error("find (for save)", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, byArray.length, byArray, byArray2.length, byArray2, null, null, pointerArray));
        if (pointerArray[0] != null) {
            MacProvider.error("save (update)", SecurityLibrary.LIBRARY.SecKeychainItemModifyContent(pointerArray[0], null, byArray3.length, byArray3));
            SecurityLibrary.LIBRARY.CFRelease(pointerArray[0]);
        } else {
            MacProvider.error("save (new)", SecurityLibrary.LIBRARY.SecKeychainAddGenericPassword(null, byArray.length, byArray, byArray2.length, byArray2, byArray3.length, byArray3, null));
        }
    }

    public void delete(String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        byte[] byArray2 = this.appName;
        Pointer[] pointerArray = new Pointer[1];
        MacProvider.error("find (for delete)", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, byArray.length, byArray, byArray2.length, byArray2, null, null, pointerArray));
        if (pointerArray[0] != null) {
            MacProvider.error("delete", SecurityLibrary.LIBRARY.SecKeychainItemDelete(pointerArray[0]));
            SecurityLibrary.LIBRARY.CFRelease(pointerArray[0]);
        }
    }

    private static void error(String string, int n) {
        if (n != 0 && n != -25300) {
            String string2;
            Pointer pointer = SecurityLibrary.LIBRARY.SecCopyErrorMessageString(n, null);
            if (pointer == null) {
                string2 = String.valueOf(n);
            } else {
                char[] cArray = new char[(int)SecurityLibrary.LIBRARY.CFStringGetLength(pointer)];
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = SecurityLibrary.LIBRARY.CFStringGetCharacterAtIndex(pointer, i);
                }
                SecurityLibrary.LIBRARY.CFRelease(pointer);
                string2 = new String(cArray) + " (" + n + ")";
            }
            LOG.log(Level.WARNING, "{0}: {1}", new Object[]{string, string2});
        }
    }
}

