/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.probes;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerPackage;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbeDescriptor;

public final class ProbeDescriptorComponent
extends JPanel {
    public ProbeDescriptorComponent(final TracerProbeDescriptor descriptor, final TracerPackage p, final SelectionHandler handler) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        JCheckBox checkBox = new JCheckBox(){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                if (this.isSelected()) {
                    handler.descriptorSelected(p, descriptor);
                } else {
                    handler.descriptorUnselected(p, descriptor);
                }
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled && descriptor.isProbeAvailable());
            }
        };
        checkBox.setOpaque(false);
        checkBox.setEnabled(descriptor.isProbeAvailable());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(3, 15, 3, 5);
        this.add((Component)checkBox, c);
        JLabel icon = new JLabel(){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled && descriptor.isProbeAvailable());
            }
        };
        Icon ic = descriptor.getProbeIcon();
        icon.setIcon(ic);
        icon.setEnabled(descriptor.isProbeAvailable());
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(3, 5, 3, 5);
        this.add((Component)icon, c);
        JLabel name = new JLabel(descriptor.getProbeName()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled && descriptor.isProbeAvailable());
            }
        };
        name.setFont(name.getFont().deriveFont(1));
        name.setEnabled(descriptor.isProbeAvailable());
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(3, 10, 0, 5);
        this.add((Component)name, c);
        JLabel descr = new JLabel(descriptor.getProbeDescription()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled && descriptor.isProbeAvailable());
            }
        };
        descr.setFont(descr.getFont().deriveFont(0));
        descr.setEnabled(descriptor.isProbeAvailable());
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, 10, 3, 5);
        this.add((Component)descr, c);
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        super.setEnabled(enabled);
        for (Component c : components = this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    public static interface SelectionHandler {
        public void descriptorSelected(TracerPackage var1, TracerProbeDescriptor var2);

        public void descriptorUnselected(TracerPackage var1, TracerProbeDescriptor var2);
    }
}

