/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import org.netbeans.core.options.keymap.api.KeyStrokeUtils;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.netbeans.modules.options.keymap.MutableShortcutsModel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ShortcutsFinderImpl
implements ShortcutsFinder {
    protected KeymapModel model;
    private volatile Map<String, Map<ShortcutAction, Set<String>>> shortcutsCache = Collections.emptyMap();

    public ShortcutsFinderImpl() {
        this(KeymapModel.create());
    }

    public ShortcutsFinderImpl(KeymapModel keymapModel) {
        this.model = keymapModel;
    }

    @Override
    public ShortcutAction findActionForShortcut(String string) {
        for (String string2 : this.model.getActionCategories()) {
            for (ShortcutAction shortcutAction : this.model.getActions(string2)) {
                String[] stringArray = this.getShortcuts(shortcutAction);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!stringArray[i].equals(string) || this.isImpliedAction(shortcutAction)) continue;
                    return shortcutAction;
                }
            }
        }
        return null;
    }

    protected boolean isImpliedAction(ShortcutAction shortcutAction) {
        return shortcutAction != null && "run-macro".equals(shortcutAction.getId());
    }

    @Override
    public ShortcutAction findActionForId(String string) {
        if (this.model.isDuplicateId(string)) {
            return null;
        }
        ShortcutAction shortcutAction = this.findActionForId(string, "", false);
        if (shortcutAction == null) {
            shortcutAction = this.findActionForId(string, "", true);
        }
        return shortcutAction;
    }

    protected ShortcutAction findActionForId(String string, String string2, boolean bl) {
        if (!string2.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (String string3 : this.model.getActionCategories()) {
            for (ShortcutAction shortcutAction : this.model.getActions(string3)) {
                String string4 = bl ? LayersBridge.getOrigActionClass(shortcutAction) : shortcutAction.getId();
                if (string4 == null || !string.equals(string4)) continue;
                return shortcutAction;
            }
        }
        return null;
    }

    @Override
    public String showShortcutsDialog() {
        final ShortcutsDialog shortcutsDialog = new ShortcutsDialog();
        shortcutsDialog.init(this);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)shortcutsDialog, ShortcutsFinderImpl.loc("Add_Shortcut_Dialog"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, (ActionListener)shortcutsDialog.getListener());
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        dialogDescriptor.setAdditionalOptions(new Object[]{shortcutsDialog.getBClear(), shortcutsDialog.getBTab()});
        dialogDescriptor.setValid(shortcutsDialog.isShortcutValid());
        shortcutsDialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null || "ShortcutsDialog.PROP_SHORTCUT_VALID".equals(propertyChangeEvent.getPropertyName())) {
                    dialogDescriptor.setValid(shortcutsDialog.isShortcutValid());
                }
            }
        });
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return shortcutsDialog.getTfShortcut().getText();
        }
        return null;
    }

    protected String getCurrentProfile() {
        return this.model.getCurrentProfile();
    }

    @Override
    public String[] getShortcuts(ShortcutAction shortcutAction) {
        String string = this.getCurrentProfile();
        Map<ShortcutAction, Set<String>> map = this.getProfileMap(string);
        Set<String> set = map.get(shortcutAction);
        if (set == null) {
            return new String[0];
        }
        return set.toArray(new String[0]);
    }

    protected void clearShortcuts(String string) {
        this.shortcutsCache.remove(string);
    }

    protected Map<ShortcutAction, Set<String>> getKeymap(String string) {
        return this.model.getKeymap(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<ShortcutAction, Set<String>> getProfileMap(String string) {
        Map<ShortcutAction, Set<String>> map = this.shortcutsCache.get(string);
        if (map == null) {
            Map<ShortcutAction, Set<String>> map2 = ShortcutsFinderImpl.convertFromEmacs(this.getKeymap(string));
            ShortcutsFinderImpl shortcutsFinderImpl = this;
            synchronized (shortcutsFinderImpl) {
                map = this.shortcutsCache.get(string);
                if (map == null) {
                    HashMap<String, Map<ShortcutAction, Set<String>>> hashMap = new HashMap<String, Map<ShortcutAction, Set<String>>>(this.shortcutsCache);
                    hashMap.put(string, map2);
                    this.shortcutsCache = hashMap;
                    map = map2;
                }
            }
        }
        return map;
    }

    @Override
    public void refreshActions() {
        this.clearCache();
        this.model.refreshActions();
    }

    protected void clearCache() {
        this.shortcutsCache = Collections.emptyMap();
    }

    @Override
    public void setShortcuts(ShortcutAction shortcutAction, Set<String> set) {
        throw new UnsupportedOperationException("Finder must be cloned first");
    }

    @Override
    public void apply() {
        throw new UnsupportedOperationException("Finder must be cloned first");
    }

    protected static String loc(String string) {
        return NbBundle.getMessage(KeymapPanel.class, (String)string);
    }

    protected static Map<ShortcutAction, Set<String>> convertFromEmacs(Map<ShortcutAction, Set<String>> map) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (String string : entry.getValue()) {
                KeyStroke[] keyStrokeArray = Utilities.stringToKeys((String)string);
                linkedHashSet.add(KeyStrokeUtils.getKeyStrokesAsText(keyStrokeArray, " "));
            }
            hashMap.put(shortcutAction, linkedHashSet);
        }
        return hashMap;
    }

    @Override
    public ShortcutsFinder.Writer localCopy() {
        MutableShortcutsModel mutableShortcutsModel = new MutableShortcutsModel(this.model, this);
        this.model.getActionCategories();
        this.model.getKeymap(this.model.getCurrentProfile());
        return mutableShortcutsModel;
    }
}

