/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public abstract class UnaryExpression
extends Expression {
    protected Expression operand;

    public UnaryExpression(Expression p0) {
        this.operand = p0;
        this.adoptChildExpression(p0);
    }

    public Expression getBaseExpression() {
        return this.operand;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        try {
            if (this.operand instanceof Literal) {
                return Literal.makeLiteral(Value.asValue(SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))));
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        try {
            if (this.operand instanceof Literal) {
                return Literal.makeLiteral(Value.asValue(SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))));
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        this.operand = this.doPromotion(this.operand, offer);
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.operand);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.operand == original) {
            this.operand = replacement;
            found = true;
        }
        return found;
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.operand.getItemType(th);
    }

    public boolean equals(Object other) {
        return this.getClass().equals(other.getClass()) && this.operand.equals(((UnaryExpression)other).operand);
    }

    public int hashCode() {
        return ("UnaryExpression " + this.getClass()).hashCode() ^ this.operand.hashCode();
    }

    public String toString() {
        String className = this.getClass().getName();
        String simpleName = className.substring(className.lastIndexOf(".") + 1);
        return simpleName + "(" + this.operand.toString() + ")";
    }

    public void explain(ExpressionPresenter out) {
        String name = this.displayExpressionName();
        if (name == null) {
            out.startElement("unaryOperator");
            String op = this.displayOperator(out.getConfiguration());
            if (op != null) {
                out.emitAttribute("op", op);
            }
        } else {
            out.startElement(name);
        }
        this.operand.explain(out);
        out.endElement();
    }

    protected String displayOperator(Configuration config) {
        return null;
    }

    protected String displayExpressionName() {
        return null;
    }
}

