/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public abstract class AtomicValue
extends Value
implements Item,
GroundedValue,
ConversionResult {
    protected AtomicType typeLabel;

    public void setTypeLabel(AtomicType type) {
        this.typeLabel = type;
    }

    public abstract Comparable getSchemaComparable();

    public abstract Object getXPathComparable(boolean var1, StringCollator var2, XPathContext var3) throws NoDynamicContextException;

    public abstract boolean equals(Object var1);

    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    public void process(XPathContext context) throws XPathException {
        context.getReceiver().append(this, 0, 2);
    }

    public final Item itemAt(int n) {
        return n == 0 ? this : null;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.typeLabel;
    }

    public AtomicType getTypeLabel() {
        return this.typeLabel;
    }

    public abstract BuiltInAtomicType getPrimitiveType();

    public final int getCardinality() {
        return 16384;
    }

    public final AtomicValue convert(AtomicType schemaType, XPathContext context) throws XPathException {
        return this.convert(schemaType, true, context).asAtomic();
    }

    protected abstract ConversionResult convertPrimitive(BuiltInAtomicType var1, boolean var2, XPathContext var3);

    public final ConversionResult convert(AtomicType targetType, boolean validate, XPathContext context) {
        CharSequence lexicalValue;
        if (targetType.isPrimitiveType()) {
            return this.convertPrimitive((BuiltInAtomicType)targetType, validate, context);
        }
        if (targetType.isAbstract()) {
            return new ValidationFailure("Cannot convert to an abstract type");
        }
        if (targetType.isExternalType()) {
            return new ValidationFailure("Cannot convert to an external type");
        }
        BuiltInAtomicType primitiveType = (BuiltInAtomicType)targetType.getPrimitiveItemType();
        ConversionResult cr = this.convertPrimitive(primitiveType, validate, context);
        if (cr instanceof ValidationFailure) {
            return cr;
        }
        if (primitiveType.getFingerprint() == 513) {
            int whitespaceAction = targetType.getWhitespaceAction(context == null ? null : context.getConfiguration().getTypeHierarchy());
            CharSequence cs = Whitespace.applyWhitespaceNormalization(whitespaceAction, ((StringValue)cr).getStringValueCS());
            cr = new StringValue(cs);
            lexicalValue = cs;
        } else {
            lexicalValue = this.getCanonicalLexicalRepresentation();
        }
        ValidationFailure vf = targetType.validate((AtomicValue)cr, lexicalValue, context == null ? Name10Checker.getInstance() : context.getConfiguration().getNameChecker());
        if (vf != null) {
            return vf;
        }
        return ((AtomicValue)cr).copyAsSubType(targetType);
    }

    public abstract AtomicValue copyAsSubType(AtomicType var1);

    public boolean isNaN() {
        return false;
    }

    public final int getLength() {
        return 1;
    }

    public final SequenceIterator iterate() {
        return SingletonIterator.makeIterator(this);
    }

    public abstract String getStringValue();

    public final SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(this);
    }

    public boolean effectiveBooleanValue() throws XPathException {
        XPathException err = new XPathException("Effective boolean value is not defined for an atomic value of type " + Type.displayTypeName(this));
        err.setIsTypeError(true);
        err.setErrorCode("FORG0006");
        throw err;
    }

    public AtomicValue getComponent(int component) throws XPathException {
        throw new UnsupportedOperationException("Data type does not support component extraction");
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (whole) {
            SimpleType stype = null;
            if (parentType instanceof SimpleType) {
                stype = (SimpleType)parentType;
            } else if (parentType instanceof ComplexType && ((ComplexType)parentType).isSimpleContent()) {
                stype = ((ComplexType)parentType).getSimpleContentType();
            }
            if (stype != null && !stype.isNamespaceSensitive()) {
                ValidationFailure err = stype.validateContent(this.getStringValueCS(), null, env.getConfiguration().getNameChecker());
                if (err != null) {
                    throw err.makeException();
                }
                return;
            }
        }
        if (parentType instanceof ComplexType && !((ComplexType)parentType).isSimpleContent() && !((ComplexType)parentType).isMixedContent() && !Whitespace.isWhite(this.getStringValueCS())) {
            XPathException err = new XPathException("Complex type " + parentType.getDescription() + " does not allow text content " + Err.wrap(this.getStringValueCS()));
            err.setIsTypeError(true);
            throw err;
        }
    }

    public AtomicValue asAtomic() {
        return this;
    }

    public GroundedValue subsequence(int start, int length) {
        if (start <= 0 && start + length > 0) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    public String toString() {
        return this.typeLabel.toString() + " (\"" + this.getStringValueCS() + "\")";
    }
}

