/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.util.SortedSet;
import nu.validator.json.JsonHandler;
import nu.validator.source.SourceHandler;
import org.xml.sax.SAXException;

public class JsonSourceHandler
implements SourceHandler {
    private static final char[] NEWLINE = new char[]{'\n'};
    private final JsonHandler handler;

    public JsonSourceHandler(JsonHandler handler) {
        this.handler = handler;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
    }

    @Override
    public void endCharHilite() throws SAXException {
    }

    @Override
    public void endRange() throws SAXException {
    }

    @Override
    public void endSource() throws SAXException {
        this.handler.endString();
        this.handler.endObject();
    }

    @Override
    public void newLine() throws SAXException {
        this.handler.characters(NEWLINE, 0, 1);
    }

    @Override
    public void startCharHilite(int oneBasedLine, int oneBasedColumn) throws SAXException {
    }

    @Override
    public void startRange(int oneBasedLine, int oneBasedColumn) throws SAXException {
    }

    @Override
    public void startSource(String type, String encoding) throws SAXException {
        this.handler.startObject();
        if (type != null) {
            this.handler.key("type");
            this.handler.string(type);
        }
        if (encoding != null) {
            this.handler.key("encoding");
            this.handler.string(encoding);
        }
        this.handler.key("code");
        this.handler.startString();
    }

    @Override
    public void setLineErrors(SortedSet<Integer> oneBasedLineErrors) throws SAXException {
    }
}

