/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssRubyPosition
extends org.w3c.css.properties.css.CssRubyPosition {
    public static final CssIdent[] allowed_values;
    public static final CssIdent inter_char;
    public static final CssIdent alternate;

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssRubyPosition() {
        this.value = initial;
    }

    public CssRubyPosition(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        boolean gotAlt = false;
        boolean gotLine = false;
        ArrayList<CssValue> v = new ArrayList<CssValue>();
        this.setByUser();
        if (check && expression.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            CssIdent ident = val.getIdent();
            if (CssIdent.isCssWide(ident) || inter_char.equals(ident)) {
                if (expression.getCount() != 1) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                this.value = val;
            } else if (!gotAlt && alternate.equals(ident)) {
                gotAlt = true;
                v.add(val);
            } else if (!gotLine && CssRubyPosition.getAllowedIdent(ident) != null) {
                gotLine = true;
                v.add(val);
            } else {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            expression.next();
            if (expression.end() || op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (!v.isEmpty()) {
            this.value = v.size() == 1 ? (CssValue)v.get(0) : new CssValueList(v);
        }
    }

    public CssRubyPosition(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        inter_char = CssIdent.getIdent("inter-character");
        alternate = CssIdent.getIdent("alternate");
        String[] _allowed_values = new String[]{"over", "under"};
        allowed_values = new CssIdent[_allowed_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssRubyPosition.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }
}

