/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.StringUtils;
import org.w3c.css.values.CssValue;

public class CssURL
extends CssValue {
    public static final int type = 2;
    String value;
    String full = null;
    private boolean addQuotes = false;
    URL base;
    URL urlValue = null;

    @Override
    public final int getType() {
        return 2;
    }

    @Override
    @Deprecated
    public void set(String s, ApplContext ac) throws InvalidParamException {
        throw new InvalidParamException("Deprecated method invocation", ac);
    }

    public void set(String s, ApplContext ac, URL base) throws InvalidParamException {
        char firstc;
        int ppos = s.indexOf(40);
        String urlHeading = s.substring(0, ppos).toLowerCase();
        String urlname = s.substring(ppos + 1, s.length() - 1).trim();
        this.base = base;
        if (!((urlname = urlname.trim()).isEmpty() || (firstc = urlname.charAt(0)) != '\"' && firstc != '\'')) {
            int l = urlname.length() - 1;
            if (firstc == urlname.charAt(l)) {
                urlname = urlname.substring(1, l);
                this.addQuotes = true;
            } else {
                throw new InvalidParamException("url", s, ac);
            }
        }
        this.value = this.filterURLData(urlname);
        this.full = null;
        if (!(urlHeading = StringUtils.convertIdent(urlHeading, ac).toLowerCase(Locale.ENGLISH)).startsWith("url")) {
            throw new InvalidParamException("url", s, ac);
        }
        if (urlname.contains("data:")) {
            return;
        }
        try {
            ac.addLinkedURI(this.getURL());
        }
        catch (MalformedURLException mex) {
            throw new InvalidParamException("url", s, ac);
        }
    }

    private String filterURLData(String source) {
        StringBuilder sb = new StringBuilder();
        block4: for (char c : source.toCharArray()) {
            switch (c) {
                case '<': {
                    sb.append("%3c");
                    continue block4;
                }
                case '>': {
                    sb.append("%3e");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public Object get() {
        return this.value;
    }

    public URL getURL() throws MalformedURLException {
        if (this.urlValue == null) {
            this.urlValue = HTTPURL.getURL(this.base, this.value);
        }
        return this.urlValue;
    }

    public String toString() {
        if (this.full != null) {
            return this.full;
        }
        StringBuilder sb = new StringBuilder("url(");
        if (this.addQuotes) {
            sb.append('\"').append(this.value).append("\")");
        } else {
            sb.append(this.value).append(')');
        }
        this.full = sb.toString();
        return this.full;
    }

    @Override
    public boolean equals(Object url) {
        return url instanceof CssURL && this.value.equals(((CssURL)url).value);
    }
}

