/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class RGB {
    static final String functionname = "rgb";
    private String output = null;
    private boolean percent = false;
    boolean isModernCss = false;
    CssValue vr;
    CssValue vg;
    CssValue vb;

    public static final CssValue filterValue(ApplContext ac, CssValue val) throws InvalidParamException {
        if (val.getRawType() != 19) {
            if (val.getType() == 5) {
                float p;
                boolean IsModernCss = ac.getCssVersion().compareTo(CssVersion.CSS3) >= 0;
                CssCheckableValue v = val.getCheckableValue();
                if (!IsModernCss && !v.isInteger()) {
                    throw new InvalidParamException(functionname, val, ac);
                }
                if (!v.warnPositiveness(ac, "RGB")) {
                    CssNumber nb = new CssNumber();
                    nb.setIntValue(0);
                    return nb;
                }
                if (val.getRawType() == 5 && (double)(p = ((CssNumber)val).getValue()) > 255.0) {
                    ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
                    CssNumber nb = new CssNumber();
                    nb.setIntValue(255);
                    return nb;
                }
            } else if (val.getType() == 4) {
                float p;
                CssCheckableValue v = val.getCheckableValue();
                if (!v.warnPositiveness(ac, "RGB")) {
                    CssNumber nb = new CssNumber();
                    nb.setIntValue(0);
                    return nb;
                }
                if (val.getRawType() == 4 && (double)(p = ((CssPercentage)val).floatValue()) > 100.0) {
                    ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
                    return new CssPercentage(100);
                }
            }
        }
        return val;
    }

    public final void setRed(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vr = RGB.filterValue(ac, val);
    }

    public final void setGreen(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vg = RGB.filterValue(ac, val);
    }

    public final void setBlue(ApplContext ac, CssValue val) throws InvalidParamException {
        this.output = null;
        this.vb = RGB.filterValue(ac, val);
    }

    public final boolean isPercent() {
        return this.percent;
    }

    public final void setPercent(boolean percent) {
        this.percent = percent;
    }

    public RGB() {
    }

    public RGB(int r, int g, int b) {
        CssNumber n = new CssNumber();
        n.setIntValue(r);
        this.vr = n;
        n = new CssNumber();
        n.setIntValue(g);
        this.vg = n;
        n = new CssNumber();
        n.setIntValue(b);
        this.vb = n;
    }

    public RGB(boolean isModernCss, int r, int g, int b) {
        this(r, g, b);
        this.isModernCss = isModernCss;
    }

    public boolean equals(RGB other) {
        if (other != null) {
            return this.vr.equals(other.vr) && this.vg.equals(other.vg) && this.vb.equals(other.vb);
        }
        return false;
    }

    protected void setRepresentationString(String s) {
        this.output = s;
    }

    protected void setModernStyle(boolean isModernCss) {
        this.isModernCss = isModernCss;
        this.output = null;
    }

    public String toString() {
        if (this.output == null) {
            StringBuilder sb = new StringBuilder(functionname).append('(');
            if (this.isModernCss) {
                sb.append(this.vr).append(' ').append(this.vg).append(' ').append(this.vb).append(')');
            } else {
                sb.append(this.vr).append(", ");
                sb.append(this.vg).append(", ");
                sb.append(this.vb).append(')');
            }
            this.output = sb.toString();
        }
        return this.output;
    }
}

