/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.GrayStream;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class BroadcastStream
extends Stream {
    final Stream[] streams;
    private static final Primitive MAKE_BROADCAST_STREAM = new Primitive("make-broadcast-stream", "&rest streams"){

        @Override
        public LispObject execute() {
            return new BroadcastStream(new Stream[0]);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            Stream[] streams = new Stream[args.length];
            for (int i = 0; i < args.length; ++i) {
                Stream s = Lisp.checkStream(args[i]);
                if (!(s instanceof Stream) || !s.isOutputStream() && !(s instanceof GrayStream)) {
                    return Lisp.type_error(args[i], Lisp.list(Symbol.SATISFIES, Symbol.OUTPUT_STREAM_P));
                }
                streams[i] = s;
            }
            return new BroadcastStream(streams);
        }
    };
    private static final Primitive BROADCAST_STREAM_STREAMS = new Primitive("broadcast-stream-streams", "broadcast-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof BroadcastStream) {
                BroadcastStream stream = (BroadcastStream)arg;
                Stream[] streams = stream.streams;
                LispObject result = Lisp.NIL;
                int i = streams.length;
                while (i-- > 0) {
                    result = new Cons(streams[i], result);
                }
                return result;
            }
            return Lisp.type_error(arg, Symbol.BROADCAST_STREAM);
        }
    };

    BroadcastStream(Stream[] streams) {
        super(Symbol.BROADCAST_STREAM);
        this.streams = streams;
        this.isOutputStream = true;
        if (streams.length == 0) {
            this.elementType = Lisp.T;
            this.isBinaryStream = true;
            this.isCharacterStream = true;
        } else {
            this.elementType = streams[streams.length - 1].getElementType();
            if (this.elementType == Symbol.CHARACTER || this.elementType == Symbol.BASE_CHAR) {
                this.isCharacterStream = true;
            } else {
                this.isBinaryStream = true;
            }
        }
    }

    public Stream[] getStreams() {
        return this.streams;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.BROADCAST_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.BROADCAST_STREAM;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.BROADCAST_STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.BROADCAST_STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public LispObject listen() {
        this.notSupported();
        return Lisp.NIL;
    }

    @Override
    public LispObject fileLength() {
        if (this.streams.length > 0) {
            return this.streams[this.streams.length - 1].fileLength();
        }
        return Fixnum.ZERO;
    }

    @Override
    public LispObject fileStringLength(LispObject arg) {
        if (this.streams.length > 0) {
            return this.streams[this.streams.length - 1].fileStringLength(arg);
        }
        return Fixnum.ONE;
    }

    @Override
    protected int _readChar() {
        this.notSupported();
        return -1;
    }

    @Override
    protected void _unreadChar(int n) {
        this.notSupported();
    }

    @Override
    protected boolean _charReady() {
        this.notSupported();
        return false;
    }

    @Override
    public void _writeChar(char c) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeChar(c);
        }
    }

    @Override
    public void _writeChars(char[] chars, int start, int end) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeChars(chars, start, end);
        }
    }

    @Override
    public void _writeString(String s) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeString(s);
        }
    }

    @Override
    public void _writeLine(String s) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeLine(s);
        }
    }

    @Override
    public int _readByte() {
        this.notSupported();
        return -1;
    }

    @Override
    public void _writeByte(int n) {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._writeByte(n);
        }
    }

    @Override
    public void _finishOutput() {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i]._finishOutput();
        }
    }

    @Override
    public void _clearInput() {
        this.notSupported();
    }

    @Override
    protected long _getFilePosition() {
        if (this.streams.length == 0) {
            return 0L;
        }
        return this.streams[this.streams.length - 1]._getFilePosition();
    }

    @Override
    protected boolean _setFilePosition(LispObject arg) {
        return false;
    }

    @Override
    public void _close() {
        this.setOpen(false);
    }

    private void notSupported() {
        Lisp.error(new TypeError("Operation is not supported for streams of type BROADCAST-STREAM."));
    }

    @Override
    public String printObject() {
        return this.unreadableString("BROADCAST-STREAM");
    }
}

