/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Util;

public class CommandLine
implements Serializable {
    private final List<String> args = new LinkedList<String>();
    private final List<Option> options = new ArrayList<Option>();

    protected CommandLine() {
    }

    protected void addArg(String arg) {
        this.args.add(arg);
    }

    protected void addOption(Option opt) {
        this.options.add(opt);
    }

    public List<String> getArgList() {
        return this.args;
    }

    public String[] getArgs() {
        String[] answer = new String[this.args.size()];
        this.args.toArray(answer);
        return answer;
    }

    public String getOptionValue(Option option) {
        if (option == null) {
            return null;
        }
        String[] values = this.getOptionValues(option);
        return values == null ? null : values[0];
    }

    public String getOptionValue(String opt) {
        return this.getOptionValue(this.resolveOption(opt));
    }

    public String[] getOptionValues(Option option) {
        ArrayList<String> values = new ArrayList<String>();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option)) continue;
            values.addAll(processedOption.getValuesList());
        }
        return values.isEmpty() ? null : values.toArray(new String[values.size()]);
    }

    public boolean hasOption(Option opt) {
        return this.options.contains(opt);
    }

    public boolean hasOption(String opt) {
        return this.hasOption(this.resolveOption(opt));
    }

    private Option resolveOption(String opt) {
        opt = Util.stripLeadingHyphens(opt);
        for (Option option : this.options) {
            if (!opt.equals(option.getOpt()) && !opt.equals(option.getLongOpt())) continue;
            return option;
        }
        return null;
    }
}

