/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.object.SPObject;
import java.util.ArrayList;
import java.util.List;

public class AbstractSPFilterPersister
implements SPPersister {
    private boolean filter = false;
    private final List<String> filteredClasses = new ArrayList<String>();
    private final SPPersister nextPersister;
    private List<String> UUIDSToIgnore;

    public AbstractSPFilterPersister(List<Class<? extends SPObject>> filteredClasses, SPPersister nextPersister) {
        for (Class<? extends SPObject> c : filteredClasses) {
            this.filteredClasses.add(c.getName());
        }
        this.nextPersister = nextPersister;
        this.UUIDSToIgnore = new ArrayList<String>();
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object oldValue, Object newValue) throws SPPersistenceException {
        if (!this.filter || !this.UUIDSToIgnore.contains(uuid)) {
            this.persistProperty(uuid, propertyName, propertyType, oldValue, newValue);
        }
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object newValue) throws SPPersistenceException {
        if (!this.filter || !this.UUIDSToIgnore.contains(uuid)) {
            this.persistProperty(uuid, propertyName, propertyType, newValue);
        }
    }

    @Override
    public void persistObject(String parentUUID, String type, String uuid, int index) throws SPPersistenceException {
        if (this.filter && this.filteredClasses.contains(type)) {
            this.UUIDSToIgnore.add(uuid);
        } else {
            this.persistObject(parentUUID, type, uuid, index);
        }
    }

    @Override
    public void removeObject(String parentUUID, String uuid) throws SPPersistenceException {
    }

    @Override
    public void begin() throws SPPersistenceException {
        this.UUIDSToIgnore = new ArrayList<String>();
        this.nextPersister.begin();
    }

    @Override
    public void commit() throws SPPersistenceException {
        this.nextPersister.commit();
    }

    @Override
    public void rollback() {
        this.nextPersister.rollback();
    }
}

