/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.session;

import ca.sqlpower.dao.session.BidirectionalConverter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.SQLPowerUtils;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;

public class SPObjectConverter
implements BidirectionalConverter<String, SPObject> {
    private final SPObject root;
    private Map<String, SPObject> lookupCache = null;

    public SPObjectConverter(SPObject root) {
        this.root = root;
    }

    @Override
    public SPObject convertToComplexType(String convertFrom) throws ConversionException {
        if (this.lookupCache != null && this.lookupCache.get(convertFrom) != null) {
            return this.lookupCache.get(convertFrom);
        }
        return SQLPowerUtils.findByUuid(this.root, convertFrom, SPObject.class);
    }

    @Override
    public String convertToSimpleType(SPObject convertFrom, Object ... additionalValues) {
        return convertFrom.getUUID();
    }

    public void setUUIDCache(Map<String, SPObject> lookupCache) {
        this.lookupCache = lookupCache;
    }

    public void removeUUIDCache() {
        this.lookupCache = null;
    }
}

