/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.graph;

import ca.sqlpower.graph.GraphModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DepthFirstSearch<V, E> {
    private static final Logger logger = Logger.getLogger(DepthFirstSearch.class);
    private Map<V, VertexInfo> vertexInfo = new HashMap<V, VertexInfo>();
    private int visitTime;
    private LinkedList<V> finishOrder = new LinkedList();
    private boolean cyclic = false;

    public void performSearch(GraphModel<V, E> model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing Search on: " + model));
        }
        Collection<V> vertices = model.getNodes();
        this.vertexInfo.clear();
        this.finishOrder.clear();
        for (V u : vertices) {
            this.vertexInfo.put((VertexInfo)u, new VertexInfo());
        }
        this.visitTime = 0;
        for (V u : vertices) {
            VertexInfo vi = this.vertexInfo.get(u);
            if (!vi.isWhite()) continue;
            this.visit(u, model);
        }
    }

    private boolean visit(V u, GraphModel<V, E> model) {
        boolean ret = true;
        VertexInfo vi = this.vertexInfo.get(u);
        vi.setDiscoveryTime(++this.visitTime);
        for (V v : model.getAdjacentNodes(u)) {
            VertexInfo vi2 = this.vertexInfo.get(v);
            if (vi2 == null) {
                logger.debug((Object)("Skipping vertex " + v + " because it is not in the set of tables to search"));
                continue;
            }
            if (vi2.isWhite()) {
                vi2.setPredecessor(u);
                this.visit(v, model);
                continue;
            }
            if (!vi2.isGrey()) continue;
            this.cyclic = true;
        }
        vi.setFinishTime(++this.visitTime);
        this.finishOrder.addFirst(u);
        return ret;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public List<V> getFinishOrder() {
        return this.finishOrder;
    }

    private class VertexInfo {
        private int discoveryTime;
        private int finishTime;
        private V predecessor;

        private VertexInfo() {
        }

        public boolean isWhite() {
            return this.discoveryTime == 0 && this.finishTime == 0;
        }

        public boolean isGrey() {
            return this.discoveryTime != 0 && this.finishTime == 0;
        }

        public boolean isBlack() {
            return this.finishTime != 0;
        }

        public int getDiscoveryTime() {
            return this.discoveryTime;
        }

        public void setDiscoveryTime(int discoveryTime) {
            this.discoveryTime = discoveryTime;
        }

        public int getFinishTime() {
            return this.finishTime;
        }

        public void setFinishTime(int finishTime) {
            this.finishTime = finishTime;
        }

        public V getPredecessor() {
            return this.predecessor;
        }

        public void setPredecessor(V predecessor) {
            this.predecessor = predecessor;
        }
    }
}

