/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DBConnection;
import ca.sqlpower.sql.PoolableStatementClosingConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.log4j.Logger;

public class StatementClosingPoolableConnectionFactory
extends PoolableConnectionFactory {
    private static final Logger logger = Logger.getLogger(StatementClosingPoolableConnectionFactory.class);

    public StatementClosingPoolableConnectionFactory(ConnectionFactory factory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) throws Exception {
        super(factory, pool, stmtPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object makeObject() throws Exception {
        Connection con = this._connFactory.createConnection();
        try {
            con.setAutoCommit(this._defaultAutoCommit);
        }
        catch (SQLException e) {
            logger.error((Object)("Couldn't set autoCommit to " + this._defaultAutoCommit + "!"), (Throwable)e);
        }
        if (!DBConnection.isOracle(con)) {
            try {
                con.setTransactionIsolation(1);
            }
            catch (SQLException e) {
                logger.error((Object)"Couldn't set transactionIsolation to TRANSACTION_READ_UNCOMMITTED!", (Throwable)e);
            }
        }
        try {
            con.setReadOnly(this._defaultReadOnly);
        }
        catch (SQLException e) {
            logger.error((Object)("Couldn't set readOnly to " + this._defaultReadOnly + "!"), (Throwable)e);
        }
        if (this._stmtPoolFactory != null) {
            KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
            con = new PoolingConnection(con, stmtpool);
            stmtpool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)con));
        }
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("select schema_version from def_param");
            if (!rs.next()) {
                throw new SQLException("def_param table has no rows");
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return new PoolableStatementClosingConnection(con, this._pool);
    }
}

