/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.PlatformSpecificConnectionOptionPanel;
import ca.sqlpower.swingui.db.DataSourceTypeCopyPropertiesPanel;
import ca.sqlpower.swingui.db.DataSourceTypeEditorTabPanel;
import ca.sqlpower.swingui.db.JDBCDriverPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;

public class DataSourceTypeEditorPanel
implements DataEntryPanel {
    private static final Logger logger = Logger.getLogger(DataSourceTypeEditorPanel.class);
    private JDBCDataSourceType dsType;
    private JPanel panel;
    private JTabbedPane tabbedPane;
    private final JTextField name = new JTextField();
    private final JTextField connectionStringTemplate = new JTextField();
    private final JTextField driverClass = new JTextField();
    private final PlatformSpecificConnectionOptionPanel template = new PlatformSpecificConnectionOptionPanel(new JTextField());
    private final JButton copyPropertiesButton;
    private final JDBCDriverPanel jdbcPanel;
    private List<DataSourceTypeEditorTabPanel> tabPanels = new ArrayList<DataSourceTypeEditorTabPanel>();

    public DataSourceTypeEditorPanel(final DataSourceCollection collection, final Window owner) {
        this.jdbcPanel = new JDBCDriverPanel(collection.getServerBaseURI());
        this.jdbcPanel.addDriverTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getPathCount() > 2) {
                    DataSourceTypeEditorPanel.this.driverClass.setText(e.getNewLeadSelectionPath().getLastPathComponent().toString());
                }
            }
        });
        this.copyPropertiesButton = new JButton(new AbstractAction("Copy Properties..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSourceTypeCopyPropertiesPanel copyPropertiesPanel = new DataSourceTypeCopyPropertiesPanel(DataSourceTypeEditorPanel.this.dsType, collection);
                JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog(copyPropertiesPanel, owner, "Copy Properties", DataEntryPanelBuilder.OK_BUTTON_LABEL);
                d.pack();
                d.setLocationRelativeTo(owner);
                d.setVisible(true);
                d.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        DataSourceTypeEditorPanel.this.editDsType(DataSourceTypeEditorPanel.this.dsType);
                    }
                });
            }
        });
        this.buildPanel();
        this.editDsType(null);
    }

    private void buildPanel() {
        this.connectionStringTemplate.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTemplate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTemplate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTemplate();
            }

            private void updateTemplate() {
                if (DataSourceTypeEditorPanel.this.dsType != null) {
                    DataSourceTypeEditorPanel.this.dsType.setJdbcUrl(DataSourceTypeEditorPanel.this.connectionStringTemplate.getText());
                    DataSourceTypeEditorPanel.this.template.setTemplate(DataSourceTypeEditorPanel.this.dsType);
                }
            }
        });
        this.tabbedPane = new JTabbedPane();
        PanelBuilder pb = new PanelBuilder(new FormLayout("4dlu,pref,4dlu,pref:grow,4dlu", "4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu, pref:grow, 4dlu"));
        CellConstraints cc = new CellConstraints();
        CellConstraints cl = new CellConstraints();
        int row = 2;
        pb.addLabel(Messages.getString("DataSourceTypeEditorPanel.nameLabel"), cl.xy(2, row), (Component)this.name, cc.xy(4, row));
        pb.addLabel(Messages.getString("DataSourceTypeEditorPanel.driverClassLabel"), cl.xy(2, row += 2), (Component)this.driverClass, cc.xy(4, row));
        pb.addLabel(Messages.getString("DataSourceTypeEditorPanel.connectionStringTemplateLabel"), cl.xy(2, row += 2), (Component)this.connectionStringTemplate, cc.xy(4, row));
        this.connectionStringTemplate.setToolTipText(Messages.getString("DataSourceTypeEditorPanel.templateToolTip"));
        pb.addTitle(Messages.getString("DataSourceTypeEditorPanel.optionsEditorPreview"), cl.xyw(2, row += 2, 3));
        pb.addLabel(Messages.getString("DataSourceTypeEditorPanel.sampleOptions"), cl.xy(2, row += 2), (Component)this.template.getPanel(), cc.xy(4, row));
        pb.add((Component)this.jdbcPanel, cc.xyw(2, row += 2, 3));
        this.tabbedPane.addTab(Messages.getString("DataSourceTypeEditorPanel.generalTab"), pb.getPanel());
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.tabbedPane, "Center");
        ButtonBarBuilder copyBar = new ButtonBarBuilder();
        copyBar.addGlue();
        copyBar.addGridded((JComponent)this.copyPropertiesButton);
        this.panel.add((Component)copyBar.getPanel(), "South");
    }

    public void editDsType(JDBCDataSourceType dst) {
        this.dsType = dst;
        if (dst == null) {
            this.name.setText("");
            this.name.setEnabled(false);
            this.driverClass.setText("");
            this.driverClass.setEnabled(false);
            this.connectionStringTemplate.setText("");
            this.connectionStringTemplate.setEnabled(false);
            this.copyPropertiesButton.setEnabled(false);
        } else {
            this.name.setText(dst.getName());
            this.name.setEnabled(true);
            this.driverClass.setText(dst.getJdbcDriver());
            this.driverClass.setEnabled(true);
            this.connectionStringTemplate.setText(dst.getJdbcUrl());
            this.connectionStringTemplate.setEnabled(true);
            this.copyPropertiesButton.setEnabled(true);
        }
        for (DataSourceTypeEditorTabPanel panel : this.tabPanels) {
            panel.editDsType(dst);
        }
        this.jdbcPanel.editDsType(dst);
    }

    @Override
    public boolean applyChanges() {
        logger.debug((Object)("Applying changes to data source type " + this.dsType));
        if (this.dsType != null) {
            for (DataSourceTypeEditorTabPanel panel : this.tabPanels) {
                panel.applyChanges();
            }
            this.dsType.setName(this.name.getText());
            this.dsType.setJdbcDriver(this.driverClass.getText());
            this.dsType.setJdbcUrl(this.connectionStringTemplate.getText());
        }
        this.jdbcPanel.applyChanges();
        return true;
    }

    @Override
    public void discardChanges() {
        logger.debug((Object)("Discarding changes to data source type " + this.dsType));
        if (this.dsType != null) {
            for (DataSourceTypeEditorTabPanel panel : this.tabPanels) {
                panel.discardChanges();
            }
            this.name.setText(this.dsType.getName());
            this.driverClass.setText(this.dsType.getJdbcDriver());
            this.connectionStringTemplate.setText(this.dsType.getJdbcUrl());
        }
        this.jdbcPanel.discardChanges();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    public void addTab(String title, DataSourceTypeEditorTabPanel tabPanel) {
        this.tabPanels.add(tabPanel);
        this.tabbedPane.addTab(title, tabPanel.getPanel());
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }
}

