/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.mailvalidator;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.mailvalidator.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.mailvalidator.MailValidation;
import org.pentaho.di.trans.steps.mailvalidator.MailValidationResult;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryMailValidator
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private boolean smtpCheck;
    private String timeout;
    private String defaultSMTP;
    private String emailSender;
    private String emailAddress;

    public JobEntryMailValidator(String n, String scr) {
        super(n, "");
        this.emailAddress = null;
        this.smtpCheck = false;
        this.timeout = "0";
        this.defaultSMTP = null;
        this.emailSender = "noreply@domain.com";
        this.setJobEntryType(JobEntryType.MAIL_VALIDATOR);
    }

    public JobEntryMailValidator() {
        this("", "");
    }

    public void setSMTPCheck(boolean smtpcheck) {
        this.smtpCheck = smtpcheck;
    }

    public boolean isSMTPCheck() {
        return this.smtpCheck;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    public String getDefaultSMTP() {
        return this.defaultSMTP;
    }

    public void setDefaultSMTP(String defaultSMTP) {
        this.defaultSMTP = defaultSMTP;
    }

    public String geteMailSender() {
        return this.emailSender;
    }

    public void seteMailSender(String emailSender) {
        this.emailSender = emailSender;
    }

    public JobEntryMailValidator(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryMailValidator je = (JobEntryMailValidator)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      ").append(XMLHandler.addTagValue((String)"smtpCheck", (boolean)this.smtpCheck));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"defaultSMTP", (String)this.defaultSMTP));
        retval.append("      ").append(XMLHandler.addTagValue((String)"emailSender", (String)this.emailSender));
        retval.append("      ").append(XMLHandler.addTagValue((String)"emailAddress", (String)this.emailAddress));
        retval.append(super.getXML());
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.smtpCheck = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"smtpCheck"));
            this.timeout = XMLHandler.getTagValue((Node)entrynode, (String)"timeout");
            this.defaultSMTP = XMLHandler.getTagValue((Node)entrynode, (String)"defaultSMTP");
            this.emailSender = XMLHandler.getTagValue((Node)entrynode, (String)"emailSender");
            this.emailAddress = XMLHandler.getTagValue((Node)entrynode, (String)"emailAddress");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("JobEntryMailValidator.Meta.UnableToLoadFromXML"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.smtpCheck = rep.getJobEntryAttributeBoolean(id_jobentry, "smtpCheck");
            this.timeout = rep.getJobEntryAttributeString(id_jobentry, "timeout");
            this.defaultSMTP = rep.getJobEntryAttributeString(id_jobentry, "defaultSMTP");
            this.emailSender = rep.getJobEntryAttributeString(id_jobentry, "emailSender");
            this.emailAddress = rep.getJobEntryAttributeString(id_jobentry, "emailAddress");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryMailValidator.Meta.UnableToLoadFromRep") + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "smtpCheck", this.smtpCheck);
            rep.saveJobEntryAttribute(id_job, this.getID(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "defaultSMTP", this.defaultSMTP);
            rep.saveJobEntryAttribute(id_job, this.getID(), "emailSender", this.emailSender);
            rep.saveJobEntryAttribute(id_job, this.getID(), "emailAddress", this.emailAddress);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryMailValidator.Meta.UnableToSaveToRep") + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        LogWriter log = LogWriter.getInstance();
        String realEmailAddress = this.environmentSubstitute(this.emailAddress);
        if (Const.isEmpty((String)realEmailAddress)) {
            log.logError(this.toString(), Messages.getString("JobEntryMailValidator.Error.EmailEmpty"), new Object[0]);
            return result;
        }
        String realSender = this.environmentSubstitute(this.emailSender);
        if (this.smtpCheck && Const.isEmpty((String)realSender)) {
            log.logError(this.toString(), Messages.getString("JobEntryMailValidator.Error.EmailSenderEmpty"), new Object[0]);
            return result;
        }
        String realDefaultSMTP = this.environmentSubstitute(this.defaultSMTP);
        int timeOut = Const.toInt((String)this.environmentSubstitute(this.timeout), (int)0);
        String[] mailsCheck = realEmailAddress.split(" ");
        boolean exitloop = false;
        boolean mailIsValid = false;
        String MailError = null;
        for (int i = 0; i < mailsCheck.length && !exitloop; ++i) {
            String email = mailsCheck[i];
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryMailValidator.CheckingMail", email), new Object[0]);
            }
            MailValidationResult resultValidator = MailValidation.isAddressValid(email, realSender, realDefaultSMTP, timeOut, this.smtpCheck);
            mailIsValid = resultValidator.isValide();
            MailError = resultValidator.getErrorMessage();
            if (log.isDetailed()) {
                if (mailIsValid) {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryMailValidator.MailValid", email), new Object[0]);
                } else {
                    log.logDetailed(this.toString(), Messages.getString("JobEntryMailValidator.MailNotValid", email), new Object[0]);
                    log.logDetailed(this.toString(), MailError, new Object[0]);
                }
            }
            if (resultValidator.isValide()) continue;
            exitloop = true;
        }
        result.setResult(mailIsValid);
        if (mailIsValid) {
            result.setNrErrors(0L);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "emailAddress", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "emailSender", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.emailValidator()));
        if (this.isSMTPCheck()) {
            JobEntryValidatorUtils.andValidator().validate(this, "defaultSMTP", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
    }
}

