/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.msaccessbulkload;

import com.healthmarketscience.jackcess.Database;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.msaccessbulkload.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryMSAccessBulkLoad
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private boolean add_result_filenames;
    private boolean include_subfolders;
    private boolean is_args_from_previous;
    public String[] source_filefolder;
    public String[] source_wildcard;
    public String[] delimiter;
    public String[] target_Db;
    public String[] target_table;
    private String limit;
    private String success_condition;
    public String SUCCESS_IF_AT_LEAST = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private int NrErrors = 0;
    private int NrSuccess = 0;
    private int NrFilesToProcess = 0;
    private boolean continueProcessing = true;
    int limitFiles = 0;

    public JobEntryMSAccessBulkLoad(String n) {
        super(n, "");
        this.limit = "10";
        this.success_condition = this.SUCCESS_IF_NO_ERRORS;
        this.add_result_filenames = false;
        this.include_subfolders = false;
        this.source_filefolder = null;
        this.source_wildcard = null;
        this.delimiter = null;
        this.target_Db = null;
        this.target_table = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.MS_ACCESS_BULK_LOAD);
    }

    public JobEntryMSAccessBulkLoad() {
        this("");
    }

    public JobEntryMSAccessBulkLoad(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryMSAccessBulkLoad je = (JobEntryMSAccessBulkLoad)super.clone();
        return je;
    }

    public void setAddResultFilenames(boolean addtoresultfilenames) {
        this.add_result_filenames = addtoresultfilenames;
    }

    public boolean isAddResultFilename() {
        return this.add_result_filenames;
    }

    public void setIncludeSubFoders(boolean includeSubfolders) {
        this.include_subfolders = includeSubfolders;
    }

    public boolean isIncludeSubFoders() {
        return this.include_subfolders;
    }

    public void setArgsFromPrevious(boolean isargsfromprevious) {
        this.is_args_from_previous = isargsfromprevious;
    }

    public boolean isArgsFromPrevious() {
        return this.is_args_from_previous;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"is_args_from_previous", (boolean)this.is_args_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filenames", (boolean)this.add_result_filenames));
        retval.append("      ").append(XMLHandler.addTagValue((String)"limit", (String)this.limit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_wildcard", (String)this.source_wildcard[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"target_db", (String)this.target_Db[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"target_table", (String)this.target_table[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.add_result_filenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filenames"));
            this.is_args_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"is_args_from_previous"));
            this.limit = XMLHandler.getTagValue((Node)entrynode, (String)"limit");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.delimiter = new String[nrFields];
            this.source_wildcard = new String[nrFields];
            this.target_Db = new String[nrFields];
            this.target_table = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.source_wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_wildcard");
                this.delimiter[i] = XMLHandler.getTagValue((Node)fnode, (String)"delimiter");
                this.target_Db[i] = XMLHandler.getTagValue((Node)fnode, (String)"target_db");
                this.target_table[i] = XMLHandler.getTagValue((Node)fnode, (String)"target_table");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobEntryMSAccessBulkLoad.Meta.UnableLoadXML", xe.getMessage()), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.add_result_filenames = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filenames");
            this.is_args_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "is_args_from_previous");
            this.limit = rep.getJobEntryAttributeString(id_jobentry, "limit");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.source_wildcard = new String[argnr];
            this.delimiter = new String[argnr];
            this.target_Db = new String[argnr];
            this.target_table = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.source_wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_wildcard");
                this.delimiter[a] = rep.getJobEntryAttributeString(id_jobentry, a, "delimiter");
                this.target_Db[a] = rep.getJobEntryAttributeString(id_jobentry, a, "target_db");
                this.target_table[a] = rep.getJobEntryAttributeString(id_jobentry, a, "target_table");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobEntryMSAccessBulkLoad.Meta.UnableLoadRep", "" + id_jobentry, dbe.getMessage()), (Throwable)dbe);
        }
    }

    private void displayResults(LogWriter log) {
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.Info.FilesToLoad", "" + this.NrFilesToProcess), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.Info.FilesLoaded", "" + this.NrSuccess), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.Info.NrErrors", "" + this.NrErrors), new Object[0]);
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
        }
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    private void addFileToResultFilenames(String fileaddentry, LogWriter log, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (log.isDebug()) {
                log.logDebug(this.toString(), " ------ ", new Object[0]);
                log.logDebug(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.FileAddedToResultFilesName", fileaddentry), new Object[0]);
            }
        }
        catch (Exception e) {
            log.logError(Messages.getString("JobEntryMSAccessBulkLoad.Error.AddingToFilenameResult"), fileaddentry + "" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_result_filenames", this.add_result_filenames);
            rep.saveJobEntryAttribute(id_job, this.getID(), "is_args_from_previous", this.is_args_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getID(), "limit", this.limit);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "source_wildcard", this.source_wildcard[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "delimiter", this.delimiter[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "target_Db", this.target_Db[i]);
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "target_table", this.target_table[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryMSAccessBulkLoad.Meta.UnableSave", "" + id_job, dbe.getMessage()), (Throwable)dbe);
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    private boolean processOneRow(LogWriter log, String sourceFileFolder, String SourceWildcard, String Delimiter, String targetDb, String targetTable, Job parentJob, Result result) {
        boolean retval = false;
        try {
            File sourcefilefolder = new File(sourceFileFolder);
            if (!sourcefilefolder.exists()) {
                log.logError(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Error.CanNotFindFile", sourceFileFolder), new Object[0]);
                return retval;
            }
            if (sourcefilefolder.isFile()) {
                retval = this.importFile(sourceFileFolder, Delimiter, targetDb, targetTable, log, result, parentJob);
            } else if (sourcefilefolder.isDirectory()) {
                File[] listFiles = sourcefilefolder.listFiles();
                int nrFiles = listFiles.length;
                if (nrFiles > 0) {
                    for (int i = 0; i < nrFiles && !parentJob.isStopped() && this.continueProcessing; ++i) {
                        File child = listFiles[i];
                        String childFullName = child.getAbsolutePath();
                        if (child.isFile()) {
                            if (Const.isEmpty((String)SourceWildcard)) {
                                retval = this.importFile(childFullName, Delimiter, targetDb, targetTable, log, result, parentJob);
                                continue;
                            }
                            if (!this.GetFileWildcard(childFullName, SourceWildcard)) continue;
                            retval = this.importFile(childFullName, Delimiter, targetDb, targetTable, log, result, parentJob);
                            continue;
                        }
                        if (!this.include_subfolders) continue;
                        this.processOneRow(log, childFullName, SourceWildcard, Delimiter, targetDb, targetTable, parentJob, result);
                    }
                } else {
                    log.logBasic(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.FolderEmpty", sourceFileFolder), new Object[0]);
                }
            } else {
                log.logError(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.UnknowType", sourceFileFolder), new Object[0]);
            }
        }
        catch (Exception e) {
            log.logError(this.toString(), e.getMessage(), new Object[0]);
            this.incrErrors();
        }
        return retval;
    }

    private boolean importFile(String sourceFilename, String delimiter, String targetFilename, String tablename, LogWriter log, Result result, Job parentJob) {
        boolean retval = false;
        try {
            this.incrFilesToProcess();
            File sourceDataFile = new File(sourceFilename);
            File targetDbFile = new File(targetFilename);
            if (!targetDbFile.exists()) {
                Database.create((File)targetDbFile);
                log.logBasic(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.DbCreated", targetFilename), new Object[0]);
            } else {
                Database db = Database.open((File)targetDbFile);
                log.logBasic(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.DbOpened", targetFilename), new Object[0]);
                if (db.getTable(tablename) != null) {
                    log.logBasic(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.TableExists", tablename), new Object[0]);
                }
                if (db != null) {
                    db.close();
                }
                log.logBasic(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.DbCosed", targetFilename), new Object[0]);
            }
            Database.open((File)targetDbFile).importFile(tablename, sourceDataFile, delimiter);
            log.logBasic(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.FileImported", sourceFilename, tablename, targetFilename), new Object[0]);
            if (this.add_result_filenames) {
                this.addFileToResultFilenames(sourceFilename, log, result, parentJob);
            }
            retval = true;
        }
        catch (Exception e) {
            log.logError(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Error.LoadingDataToFile", sourceFilename, targetFilename, e.getMessage()), new Object[0]);
        }
        if (retval) {
            this.incrSuccess();
        } else {
            this.incrErrors();
        }
        return retval;
    }

    private void incrErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.continueProcessing = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void incrSuccess() {
        ++this.NrSuccess;
    }

    private void incrFilesToProcess() {
        ++this.NrFilesToProcess;
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        result.setResult(false);
        this.NrErrors = 0;
        this.NrSuccess = 0;
        this.NrFilesToProcess = 0;
        this.continueProcessing = true;
        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
        String[] vsourceFilefolder = this.source_filefolder;
        String[] vsourceWildcard = this.source_wildcard;
        String[] vsourceDelimiter = this.delimiter;
        String[] targetDb = this.target_Db;
        String[] targetTable = this.target_table;
        try {
            if (this.is_args_from_previous && log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.Log.ArgFromPrevious.Found", (rows != null ? rows.size() : 0) + ""), new Object[0]);
            }
            if (this.is_args_from_previous && rows != null) {
                for (int iteration = 0; iteration < rows.size() && !parentJob.isStopped() && this.continueProcessing; ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String vSourceFileFolder_previous = resultRow.getString(0, null);
                    String vSourceWildcard_previous = resultRow.getString(1, null);
                    String vDelimiter_previous = resultRow.getString(2, null);
                    String vTargetDb_previous = resultRow.getString(3, null);
                    String vTargetTable_previous = resultRow.getString(4, null);
                    this.processOneRow(log, vSourceFileFolder_previous, vSourceWildcard_previous, vDelimiter_previous, vTargetDb_previous, vTargetTable_previous, parentJob, result);
                }
            } else if (vsourceFilefolder != null && targetDb != null && targetTable != null) {
                for (int i = 0; i < vsourceFilefolder.length && !parentJob.isStopped() && this.continueProcessing; ++i) {
                    String realSourceFileFolder = this.environmentSubstitute(vsourceFilefolder[i]);
                    String realSourceWildcard = this.environmentSubstitute(vsourceWildcard[i]);
                    String realSourceDelimiter = this.environmentSubstitute(vsourceDelimiter[i]);
                    String realTargetDb = this.environmentSubstitute(targetDb[i]);
                    String realTargetTable = this.environmentSubstitute(targetTable[i]);
                    this.processOneRow(log, realSourceFileFolder, realSourceWildcard, realSourceDelimiter, realTargetDb, realTargetTable, parentJob, result);
                }
            }
        }
        catch (Exception e) {
            this.incrErrors();
            log.logError(this.toString(), Messages.getString("JobEntryMSAccessBulkLoad.UnexpectedError", e.getMessage()), new Object[0]);
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesInput((long)this.NrFilesToProcess);
        result.setNrLinesWritten((long)this.NrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        this.displayResults(log);
        return result;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST) || this.NrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }
}

