/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap<K, V>
implements Map<K, V> {
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private Object[] keyValues;

    public ArrayMap() {
        this.keyValues = EMPTY_OBJECTS;
    }

    public ArrayMap(Map<K, V> map) {
        this.keyValues = new Object[map.size() * 2];
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keyValues[i++] = entry.getKey();
            this.keyValues[i++] = entry.getValue();
        }
    }

    public static <K, V> Map<K, V> of(K key, V value, Object ... keyValues) {
        return new ArrayMap<K, V>(Olap4jUtil.mapOf(key, value, keyValues));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public int size() {
        return this.keyValues.length / 2;
    }

    @Override
    public boolean isEmpty() {
        return this.keyValues.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    private int indexOfKey(Object key) {
        for (int i = 0; i < this.keyValues.length; i += 2) {
            if (!Olap4jUtil.equal(this.keyValues[i], key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 1; i < this.keyValues.length; i += 2) {
            if (!Olap4jUtil.equal(this.keyValues[i], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int i = this.indexOfKey(key);
        if (i >= 0) {
            return (V)this.keyValues[i + 1];
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        int i = this.indexOfKey(key);
        if (i >= 0) {
            Object v = this.keyValues[i + 1];
            this.keyValues[i + 1] = value;
            return (V)v;
        }
        Object[] old = this.keyValues;
        this.keyValues = new Object[this.keyValues.length + 2];
        System.arraycopy(old, 0, this.keyValues, 0, old.length);
        this.keyValues[old.length] = key;
        this.keyValues[old.length + 1] = value;
        return null;
    }

    @Override
    public V remove(Object key) {
        int i = this.indexOfKey(key);
        if (i >= 0) {
            Object v = this.keyValues[i + 1];
            this.removeInternal(i);
            return (V)v;
        }
        return null;
    }

    private void removeInternal(int i) {
        if (this.keyValues.length == 2) {
            this.keyValues = EMPTY_OBJECTS;
        }
        Object[] old = this.keyValues;
        this.keyValues = new Object[this.keyValues.length - 2];
        System.arraycopy(old, 0, this.keyValues, 0, i);
        System.arraycopy(old, i + 2, this.keyValues, i, old.length - i - 2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (this.keyValues.length == 0) {
            this.keyValues = new Object[m.size() * 2];
            int i = 0;
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.keyValues[i++] = entry.getKey();
                this.keyValues[i++] = entry.getValue();
            }
        } else {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.keyValues = EMPTY_OBJECTS;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueList();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ArrayMap.this.keyValues.length;
                }

                @Override
                public Map.Entry<K, V> next() {
                    Pair<Object, Object> entry = new Pair<Object, Object>(ArrayMap.this.keyValues[this.i], ArrayMap.this.keyValues[this.i + 1]);
                    this.i += 2;
                    return entry;
                }

                @Override
                public void remove() {
                    ArrayMap.this.removeInternal(this.i);
                }
            };
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueList
    extends AbstractList<V> {
        private ValueList() {
        }

        @Override
        public V get(int index) {
            return ArrayMap.this.keyValues[index * 2 + 1];
        }

        @Override
        public int size() {
            return ArrayMap.this.keyValues.length / 2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ArrayMap.this.keyValues.length;
                }

                @Override
                public K next() {
                    Object k = ArrayMap.this.keyValues[this.i];
                    this.i += 2;
                    return k;
                }

                @Override
                public void remove() {
                    ArrayMap.this.removeInternal(this.i);
                }
            };
        }

        @Override
        public int size() {
            return ArrayMap.this.size();
        }
    }
}

