/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.type;

import org.olap4j.OlapException;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.type.ScalarType;
import org.olap4j.type.Type;

public class MemberType
implements Type {
    private final Hierarchy hierarchy;
    private final Dimension dimension;
    private final Level level;
    private final Member member;
    private final String digest;
    private static final MemberType Unknown = new MemberType(null, null, null, null);

    public MemberType(Dimension dimension, Hierarchy hierarchy, Level level, Member member) {
        this.dimension = dimension;
        this.hierarchy = hierarchy;
        this.level = level;
        this.member = member;
        if (member != null) {
            assert (level != null);
            assert (member.getLevel().equals(level));
        }
        if (level != null) {
            assert (hierarchy != null);
            assert (level.getHierarchy().equals(hierarchy));
        }
        if (hierarchy != null) {
            assert (dimension != null);
            assert (hierarchy.getDimension().equals(dimension));
        }
        StringBuilder buf = new StringBuilder("MemberType<");
        if (member != null) {
            buf.append("member=").append(member.getUniqueName());
        } else if (level != null) {
            buf.append("level=").append(level.getUniqueName());
        } else if (hierarchy != null) {
            buf.append("hierarchy=").append(hierarchy.getUniqueName());
        } else if (dimension != null) {
            buf.append("dimension=").append(dimension.getUniqueName());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public String toString() {
        return this.digest;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Level getLevel() {
        return this.level;
    }

    public Member getMember() {
        return this.member;
    }

    public boolean usesDimension(Dimension dimension, boolean maybe) {
        if (this.dimension == null) {
            return maybe;
        }
        return this.dimension.equals(dimension);
    }

    Type getValueType() {
        return new ScalarType();
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    static MemberType forType(Type type) throws OlapException {
        if (type instanceof MemberType) {
            return (MemberType)type;
        }
        return new MemberType(type.getDimension(), type.getHierarchy(), type.getLevel(), null);
    }
}

