/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic;

import ca.sqlpower.architect.ArchitectProject;
import ca.sqlpower.architect.ddl.DB2DDLGenerator;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.H2DDLGenerator;
import ca.sqlpower.architect.ddl.HSQLDBDDLGenerator;
import ca.sqlpower.architect.ddl.MySqlDDLGenerator;
import ca.sqlpower.architect.ddl.OracleDDLGenerator;
import ca.sqlpower.architect.ddl.PostgresDDLGenerator;
import ca.sqlpower.architect.ddl.SQLServer2000DDLGenerator;
import ca.sqlpower.architect.ddl.SQLServer2005DDLGenerator;
import ca.sqlpower.architect.ddl.SQLServerDDLGenerator;
import ca.sqlpower.architect.ddl.critic.Critic;
import ca.sqlpower.architect.ddl.critic.CriticGrouping;
import ca.sqlpower.architect.ddl.critic.CriticManager;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import java.util.Collections;
import java.util.List;

public abstract class CriticAndSettings
extends AbstractSPObject
implements Critic {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();
    private Severity severity;
    private final String platformType;
    private boolean started;

    @Constructor
    public CriticAndSettings(@ConstructorParameter(propertyName="platformType") String platformType, @ConstructorParameter(propertyName="name") String name) {
        this.platformType = platformType;
        this.severity = Severity.ERROR;
        this.setName(name);
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException("The critic " + this.getName() + " has been started already.");
        }
        this.started = true;
    }

    @Override
    public void end() {
        this.started = false;
    }

    @Mutator
    public void setSeverity(Severity severity) {
        Severity oldSeverity = this.severity;
        this.severity = severity;
        this.firePropertyChange("severity", (Object)oldSeverity, (Object)severity);
    }

    @Override
    @Accessor
    public Severity getSeverity() {
        return this.severity;
    }

    protected boolean removeChildImpl(SPObject child) {
        return false;
    }

    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    public List<? extends SPObject> getChildren() {
        return Collections.emptyList();
    }

    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
    }

    @Accessor
    public String getPlatformType() {
        return this.platformType;
    }

    @Accessor
    public CriticGrouping getParent() {
        return (CriticGrouping)super.getParent();
    }

    @Mutator
    public void setParent(SPObject parent) {
        if (parent != null && !(parent instanceof CriticGrouping)) {
            throw new IllegalArgumentException("The parent of a critic must be a CriticGrouping.");
        }
        super.setParent(parent);
    }

    protected ArchitectSwingSession getSession() {
        CriticGrouping grouping = this.getParent();
        if (grouping == null) {
            return null;
        }
        CriticManager manager = grouping.getParent();
        if (manager == null) {
            return null;
        }
        ArchitectProject project = manager.getParent();
        if (project == null) {
            return null;
        }
        ArchitectSwingSession session = (ArchitectSwingSession)project.getSession();
        return session;
    }

    public static enum StarterPlatformTypes {
        GENERIC("Generic", DDLGenerator.class),
        POSTGRESQL("PostgreSQL", PostgresDDLGenerator.class),
        MY_SQL("MySQL", MySqlDDLGenerator.class),
        SQL_SERVER("SQL Server", SQLServerDDLGenerator.class),
        SQL_SERVER_2000("SQL Server 2000", SQLServer2000DDLGenerator.class),
        SQL_SERVER_2005("SQL Server 2005", SQLServer2005DDLGenerator.class),
        ORACLE("Oracle", OracleDDLGenerator.class),
        DB2("DB2", DB2DDLGenerator.class),
        H2("H2", H2DDLGenerator.class),
        HSQLDB("HSQLDB", HSQLDBDDLGenerator.class),
        CONFIGURATION("Configuration", DDLGenerator.class);

        private final String name;
        private final Class<? extends DDLGenerator>[] associatedGenerators;

        private StarterPlatformTypes(String name, Class<? extends DDLGenerator> ... associatedGenerators) {
            this.name = name;
            this.associatedGenerators = associatedGenerators;
        }

        public String getName() {
            return this.name;
        }

        public static StarterPlatformTypes getByGroupName(String name) {
            for (StarterPlatformTypes type : StarterPlatformTypes.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return null;
        }

        public boolean isAssociated(Class<? extends DDLGenerator> associatedGenerator) {
            for (Class<? extends DDLGenerator> generatorClass : this.associatedGenerators) {
                if (!generatorClass.isAssignableFrom(associatedGenerator)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum Severity {
        ERROR,
        WARNING,
        IGNORE;

    }
}

