/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.enterprise;

import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.dao.FriendlyRuntimeSPPersistenceException;
import ca.sqlpower.dao.MessageSender;
import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.SPSessionPersister;
import ca.sqlpower.dao.json.SPJSONMessageDecoder;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.enterprise.AbstractNetworkConflictResolver;
import ca.sqlpower.enterprise.JSONMessage;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.util.MonitorableImpl;
import ca.sqlpower.util.RunnableDispatcher;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import com.enterprisedt.util.debug.Logger;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.security.AccessDeniedException;

public class ArchitectNetworkConflictResolver
extends AbstractNetworkConflictResolver
implements MessageSender<JSONObject> {
    private static final Logger logger = Logger.getLogger(ArchitectNetworkConflictResolver.class);
    private ArchitectClientSideSession session;
    private final List<PostTransactionListener> postTransactionListeners = new ArrayList<PostTransactionListener>();

    public ArchitectNetworkConflictResolver(ProjectLocation projectLocation, SPJSONMessageDecoder jsonDecoder, HttpClient inboundHttpClient, HttpClient outboundHttpClient, ArchitectClientSideSession session) {
        super(projectLocation, jsonDecoder, inboundHttpClient, outboundHttpClient, (RunnableDispatcher)session);
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(boolean reflush) {
        block36: {
            if (this.postingJSON.get() && !reflush) {
                return;
            }
            MonitorableImpl monitor = null;
            long startTimeMillis = System.currentTimeMillis();
            long messageLength = this.messageBuffer.length();
            try {
                long timestamp;
                int newRev;
                String json;
                this.postingJSON.set(true);
                if (this.session.getStatusInformation() != null) {
                    monitor = this.session.getStatusInformation().createProgressMonitor();
                    monitor.setJobSize(Integer.valueOf(this.messageBuffer.length() + 2));
                    monitor.setMessage("Saving");
                    monitor.setProgress(0);
                    final MonitorableImpl finalMonitor = monitor;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (finalMonitor.getProgress() < finalMonitor.getJobSize()) {
                                try {
                                    Thread.sleep((long)ArchitectNetworkConflictResolver.this.currentWaitPerPersist);
                                }
                                catch (InterruptedException e) {
                                    throw new RuntimeException(e);
                                }
                                if (finalMonitor.isCancelled() || finalMonitor.isFinished()) break;
                                finalMonitor.incrementProgress();
                            }
                            finalMonitor.setMessage("Completing server update.");
                        }
                    }).start();
                }
                JSONMessage response = null;
                try {
                    for (PostTransactionListener l : this.postTransactionListeners) {
                        l.preServerSend();
                    }
                    response = this.postJsonArray(this.messageBuffer.toString());
                    for (PostTransactionListener l : this.postTransactionListeners) {
                        l.postServerSend();
                    }
                }
                catch (AccessDeniedException e) {
                    ArrayList<AbstractNetworkConflictResolver.UpdateListener> listenersToRemove = new ArrayList<AbstractNetworkConflictResolver.UpdateListener>();
                    for (AbstractNetworkConflictResolver.UpdateListener listener : this.updateListeners) {
                        if (!listener.updateException((AbstractNetworkConflictResolver)this, (Throwable)e)) continue;
                        listenersToRemove.add(listener);
                    }
                    this.updateListeners.removeAll(listenersToRemove);
                    if (this.upf == null) {
                        throw e;
                    }
                    this.upf.createUserPrompter("You do not have sufficient privileges to perform that action. Please hit the refresh button to synchronize with the server.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, (Object)"OK", new String[]{"OK"}).promptUser(new Object[]{""});
                    if (monitor != null) {
                        monitor.setFinished(true);
                    }
                    this.postingJSON.set(false);
                    this.clear(true);
                    return;
                }
                if (response.isSuccessful()) {
                    try {
                        JSONObject jsonObj = new JSONObject(response.getBody());
                        this.currentRevision = jsonObj.getInt("currentRevision");
                        this.serverTimestamp = jsonObj.getLong("serverTimestamp");
                        if (logger.isDebugEnabled()) {
                            logger.debug("Setting currentRevision to: " + this.currentRevision + " and serverTimestamp to: " + this.serverTimestamp);
                        }
                    }
                    catch (JSONException e) {
                        throw new RuntimeException("Could not update current revision" + e.getMessage());
                    }
                    long endTime = System.currentTimeMillis();
                    if (messageLength != 0L) {
                        double processTimePerObj = (double)(endTime - startTimeMillis) / (double)messageLength;
                        this.currentWaitPerPersist = this.currentWaitPerPersist * 0.9 + processTimePerObj * 0.1;
                    }
                    break block36;
                }
                if (response.getStatusCode() == 403) {
                    this.updateListeners.clear();
                    if (this.projectLocation.getUUID().equals("system")) {
                        if (this.upf != null) {
                            this.upf.createUserPrompter("Server at " + this.projectLocation.getServiceInfo().getServerAddress() + "has failed since your session began." + " Please restart the program to synchronize the system workspace with the server.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, new String[]{"OK"}).promptUser(new Object[0]);
                        }
                    } else if (this.upf != null) {
                        this.upf.createUserPrompter("Server at " + this.projectLocation.getServiceInfo().getServerAddress() + " has failed since your session began." + " Please use the refresh button to synchronize workspace " + this.projectLocation.getName() + " with the server.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, new String[]{"OK"}).promptUser(new Object[0]);
                    }
                    return;
                }
                if (!reflush) {
                    this.fillOutboundPersistedLists();
                }
                try {
                    SPSessionPersister.undoForSession((SPObject)this.session.getWorkspace(), new LinkedList(this.outboundObjectsToAdd.values()), (Multimap)LinkedListMultimap.create((Multimap)this.outboundPropertiesToChange), new LinkedList(this.outboundObjectsToRemove.values()), (SessionPersisterSuperConverter)this.converter);
                }
                catch (Exception e) {
                    throw new RuntimeException("Reflush failed on rollback", e);
                }
                if (!response.isSuccessful() && response.getStatusCode() == 412) {
                    logger.info("Friendly error occurred, " + response);
                    throw new FriendlyRuntimeSPPersistenceException(response.getBody());
                }
                try {
                    JSONObject jsonObject = new JSONObject(response.getBody());
                    json = jsonObject.getString("data");
                    newRev = jsonObject.getInt("currentRevision");
                    timestamp = jsonObject.getLong("serverTimestamp");
                }
                catch (Exception e) {
                    throw new RuntimeException("Reflush failed on getJson", e);
                }
                this.fillInboundPersistedLists(json);
                this.decodeMessage(new JSONTokener(json), newRev, timestamp);
                List<AbstractNetworkConflictResolver.ConflictMessage> conflicts = this.detectConflicts();
                if (conflicts.size() == 0) {
                    try {
                        this.listener.clear();
                        for (Map.Entry entry : this.outboundObjectsToAdd.entrySet()) {
                            ((PersistedSPObject)entry.getValue()).setLoaded(false);
                        }
                        SPSessionPersister.redoForSession((SPObject)this.getWorkspace(), new LinkedList(this.outboundObjectsToAdd.values()), (Multimap)LinkedListMultimap.create((Multimap)this.outboundPropertiesToChange), new LinkedList(this.outboundObjectsToRemove.values()), (SessionPersisterSuperConverter)this.converter);
                        this.flush(true);
                        break block36;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Reflush failed on rollforward", ex);
                    }
                }
                String message = "";
                StringBuilder sb = new StringBuilder();
                message = message + "Your changes have been discarded due to a conflict between you and another user: \n";
                for (int i = 0; i < 10 && i < conflicts.size(); ++i) {
                    sb.append(conflicts.get(i).getMessage() + "\n");
                }
                message = sb.toString();
                this.session.createUserPrompter(message, UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, "OK", "OK").promptUser(new Object[]{""});
            }
            finally {
                if (monitor != null) {
                    monitor.setFinished(true);
                }
                this.postingJSON.set(false);
                this.clear(true);
            }
        }
    }

    protected List<AbstractNetworkConflictResolver.ConflictMessage> detectConflicts() {
        List conflicts = this.checkForSimultaneousEdit();
        this.allowSimultaneousAdditionsUnderDB(conflicts);
        this.disallowColumnMappingsPointingToSameColumn(conflicts);
        return conflicts;
    }

    private void disallowColumnMappingsPointingToSameColumn(List<AbstractNetworkConflictResolver.ConflictMessage> conflicts) {
        Set<String> duplicates = this.getColumnMappingChanges((Multimap<String, PersistedSPOProperty>)this.outboundPropertiesToChange);
        duplicates.retainAll(this.getColumnMappingChanges((Multimap<String, PersistedSPOProperty>)this.inboundPropertiesToChange));
        for (String duplicate : duplicates) {
            String[] ids = duplicate.split("\\:");
            String relationshipId = ids[0];
            String columnId = ids[1];
            String relationshipName = this.session.getWorkspace().getObjectInTree(relationshipId).getName();
            String columnName = this.session.getWorkspace().getObjectInTree(columnId).getName();
            String message = "More than one column mapping of relationship " + relationshipName + " points to the column " + columnName;
            conflicts.add(new AbstractNetworkConflictResolver.ConflictMessage((AbstractNetworkConflictResolver)this, message, AbstractNetworkConflictResolver.ConflictCase.SPECIAL_CASE, new String[]{relationshipId, columnId}));
        }
    }

    private Set<String> getColumnMappingChanges(Multimap<String, PersistedSPOProperty> properties) {
        HashSet<String> changes = new HashSet<String>();
        for (String uuid : properties.keySet()) {
            SPObject spo = this.session.getWorkspace().getObjectInTree(uuid);
            PersistedSPObject o = (PersistedSPObject)this.outboundObjectsToAdd.get(uuid);
            try {
                String parentId;
                Class<?> type;
                if (spo != null) {
                    type = spo.getClass();
                    parentId = spo.getParent().getUUID();
                } else {
                    if (o == null) continue;
                    type = Class.forName(o.getType(), true, ArchitectNetworkConflictResolver.class.getClassLoader());
                    parentId = o.getParentUUID();
                }
                if (!SQLRelationship.ColumnMapping.class.isAssignableFrom(type)) continue;
                for (PersistedSPOProperty p : properties.get((Object)uuid)) {
                    if (p.getDataType() != SPPersister.DataType.REFERENCE) continue;
                    changes.add(parentId + ":" + (String)p.getNewValue());
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return changes;
    }

    private void allowSimultaneousAdditionsUnderDB(List<AbstractNetworkConflictResolver.ConflictMessage> conflicts) {
        Iterator<AbstractNetworkConflictResolver.ConflictMessage> iterator = conflicts.iterator();
        LinkedList<PersistedSPObject> indexUpdates = new LinkedList<PersistedSPObject>();
        while (iterator.hasNext()) {
            AbstractNetworkConflictResolver.ConflictMessage conflict = iterator.next();
            if (conflict.getConflictCase() != AbstractNetworkConflictResolver.ConflictCase.SIMULTANEOUS_ADDITION) continue;
            PersistedSPObject o = (PersistedSPObject)this.outboundObjectsToAdd.get(conflict.getObjectId(0));
            SPObject parent = this.session.getWorkspace().getObjectInTree(o.getParentUUID());
            if (parent == this.session.getTargetDatabase()) {
                iterator.remove();
                int size = this.session.getTargetDatabase().getChildren().size();
                indexUpdates.add(new PersistedSPObject(o.getParentUUID(), o.getType(), o.getUUID(), size));
                continue;
            }
            if (parent != this.session.getWorkspace().getPlayPenContentPane()) continue;
            iterator.remove();
            PlayPenContentPane cp = this.session.getWorkspace().getPlayPenContentPane();
            try {
                Class<?> type = Class.forName(o.getType(), true, ArchitectNetworkConflictResolver.class.getClassLoader());
                int newIndex = -1;
                if (PlayPenContentPane.isDependentComponentType(type)) {
                    if (o.getIndex() < cp.getFirstDependentComponentIndex()) {
                        newIndex = cp.getChildren().size();
                    }
                } else if (o.getIndex() >= cp.getFirstDependentComponentIndex() && o.getIndex() > 0) {
                    newIndex = cp.getFirstDependentComponentIndex() - 1;
                }
                if (newIndex <= -1) continue;
                indexUpdates.add(new PersistedSPObject(o.getParentUUID(), o.getType(), o.getUUID(), newIndex));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        for (PersistedSPObject o : indexUpdates) {
            this.outboundObjectsToAdd.put(o.getUUID(), o);
        }
    }

    protected SPObject getWorkspace() {
        return this.session.getWorkspace();
    }

    public void addPostTransactionListener(PostTransactionListener l) {
        this.postTransactionListeners.add(l);
    }

    public void removePostTransactionListener(PostTransactionListener l) {
        this.postTransactionListeners.remove(l);
    }

    public static interface PostTransactionListener {
        public void preServerSend();

        public void postServerSend();
    }
}

