/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.dbtree.DBTreeModel;
import ca.sqlpower.architect.swingui.olap.CubeEditPanel;
import ca.sqlpower.query.Container;
import ca.sqlpower.query.Item;
import ca.sqlpower.query.ItemContainer;
import ca.sqlpower.query.Query;
import ca.sqlpower.query.QueryImpl;
import ca.sqlpower.query.SQLJoin;
import ca.sqlpower.query.StringItem;
import ca.sqlpower.query.TableContainer;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLDatabaseMapping;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.querypen.QueryPen;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class JoinEntryPanel
implements DataEntryPanel {
    private final JPanel panel = new JPanel();
    private final QueryPen pen;
    private final Action noExecutionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    private final Query model;
    private final SQLDatabase db;
    private final ArchitectSwingSession session;
    private final CubeEditPanel editPanel;

    public JoinEntryPanel(ArchitectSwingSession session, SQLDatabase db, CubeEditPanel editPanel, MondrianModel.Join join) {
        this.session = session;
        this.db = db;
        this.editPanel = editPanel;
        this.model = new QueryImpl((SQLDatabaseMapping)session);
        if (join != null) {
            this.addSQLJoinsToModel(join);
        }
        this.pen = new QueryPen(this.noExecutionAction, this.model, false);
        this.pen.setExecuteIcon(new ImageIcon(QueryPen.class.getClassLoader().getResource("icons/auto_layout16.png")));
        this.buildUI();
    }

    private List<Container> addSQLJoinsToModel(MondrianModel.Join join) {
        Container rightContainer;
        Container leftContainer;
        ArrayList<Container> tablesRight = new ArrayList<Container>();
        ArrayList<Container> tablesLeft = new ArrayList<Container>();
        if (join.getLeft() instanceof MondrianModel.Join) {
            tablesLeft.addAll(this.addSQLJoinsToModel((MondrianModel.Join)join.getLeft()));
        }
        if (join.getRight() instanceof MondrianModel.Join) {
            tablesRight.addAll(this.addSQLJoinsToModel((MondrianModel.Join)join.getRight()));
        }
        if ((leftContainer = this.createContainerForRelation(join.getLeft())) != null) {
            tablesLeft.add(leftContainer);
        }
        if ((rightContainer = this.createContainerForRelation(join.getRight())) != null) {
            tablesRight.add(rightContainer);
        }
        if (leftContainer == null) {
            if (join.getLeftAlias() == null || join.getLeftAlias().trim().length() == 0) {
                throw new IllegalStateException("Expecting 'leftAlias' to specify which table contains the " + join.getLeftKey() + " key.");
            }
            for (Container c : tablesLeft) {
                if (!c.getName().equals(join.getLeftAlias())) continue;
                leftContainer = c;
                break;
            }
            if (leftContainer == null) {
                throw new IllegalStateException("Could not find the table for the 'leftAlias' " + join.getLeftAlias());
            }
        }
        if (rightContainer == null) {
            if (join.getRightAlias() == null || join.getRightAlias().trim().length() == 0) {
                throw new IllegalStateException("Expecting 'rightAlias' to specify which table contains the " + join.getRightKey() + " key.");
            }
            for (Container c : tablesRight) {
                if (!c.getName().equals(join.getRightAlias())) continue;
                rightContainer = c;
                break;
            }
            if (rightContainer == null) {
                throw new IllegalStateException("Could not find the table for the 'rightAlias' " + join.getRightAlias());
            }
        }
        Item leftItem = null;
        for (Item item : leftContainer.getItems()) {
            if (!join.getLeftKey().equals(item.getName())) continue;
            leftItem = item;
            break;
        }
        if (leftItem == null) {
            throw new IllegalStateException("Could not find the 'leftKey' " + join.getLeftKey() + " from the table " + leftContainer.getName());
        }
        Item rightItem = null;
        for (Item item : rightContainer.getItems()) {
            if (!join.getRightKey().equals(item.getName())) continue;
            rightItem = item;
            break;
        }
        if (leftItem == null) {
            throw new IllegalStateException("Could not find the 'rightKey' " + join.getRightKey() + " from the table " + rightContainer.getName());
        }
        SQLJoin sqlJoin = new SQLJoin(leftItem, rightItem);
        this.model.addJoin(sqlJoin);
        tablesRight.addAll(tablesLeft);
        return tablesRight;
    }

    private Container createContainerForRelation(MondrianModel.RelationOrJoin relation) {
        if (relation instanceof MondrianModel.Table) {
            SQLTable sqlTable;
            MondrianModel.Table table1 = (MondrianModel.Table)relation;
            try {
                sqlTable = this.db.getTableByName(null, table1.getSchema(), table1.getName());
            }
            catch (SQLObjectException e) {
                throw new RuntimeException(e);
            }
            TableContainer container = new TableContainer(this.model.getDatabase(), sqlTable);
            this.model.addTable((Container)container);
            return container;
        }
        if (relation instanceof MondrianModel.InlineTable) {
            MondrianModel.InlineTable table = (MondrianModel.InlineTable)relation;
            ItemContainer inlineContainer = new ItemContainer(table.getName());
            for (OLAPObject child : table.getChildren(OLAPObject.class)) {
                StringItem childItem = new StringItem(child.getName());
                inlineContainer.addItem((Item)childItem);
            }
            this.model.addTable((Container)inlineContainer);
            return inlineContainer;
        }
        if (relation instanceof MondrianModel.Join) {
            return null;
        }
        throw new UnsupportedOperationException("Cannot create a container of the type " + ((Object)((Object)relation)).getClass() + " for the object " + (Object)((Object)relation));
    }

    private void buildUI() {
        DBTreeModel treeModel;
        DBTree tree;
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("fill:max(500dlu;pref):grow", "pref, fill:max(300dlu;pref):grow"), this.panel);
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.pen.getDeleteButton());
        toolbar.add(this.pen.getCreateJoinButton());
        toolbar.addSeparator();
        toolbar.add(this.pen.getZoomSliderContainer());
        builder.append((Component)toolbar);
        builder.nextLine();
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.add((Component)this.pen.getScrollPane(), "left");
        SQLObjectRoot root = new SQLObjectRoot();
        try {
            root.addChild((SQLObject)this.db);
            tree = new DBTree(this.session);
            treeModel = new DBTreeModel(root, tree);
        }
        catch (SQLObjectException e) {
            throw new RuntimeException(e);
        }
        tree.setModel(treeModel);
        tree.setPopupMenuEnabled(false);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)new JLabel(this.db.getName()), "North");
        treePanel.add(new JScrollPane(tree));
        splitPane.add((Component)treePanel, "right");
        splitPane.setResizeWeight(0.95);
        builder.append((Component)splitPane);
    }

    private List<MondrianModel.Relation> getRelationList(MondrianModel.Join join) {
        if (join == null) {
            return null;
        }
        ArrayList<MondrianModel.Relation> list = new ArrayList<MondrianModel.Relation>();
        if (join.getLeft() instanceof MondrianModel.Join) {
            list.addAll(this.getRelationList((MondrianModel.Join)join.getLeft()));
        } else {
            list.add((MondrianModel.Relation)join.getLeft());
        }
        if (join.getRight() instanceof MondrianModel.Join) {
            list.addAll(this.getRelationList((MondrianModel.Join)join.getRight()));
        } else {
            list.add((MondrianModel.Relation)join.getRight());
        }
        return list;
    }

    public boolean applyChanges() {
        ArrayList joins = new ArrayList(this.model.getJoins());
        Collections.sort(joins, new compareByColumnCount());
        HashMap<Container, MondrianModel.Join> tableToJoinMap = new HashMap<Container, MondrianModel.Join>();
        MondrianModel.Join join = null;
        for (SQLJoin sqlJoin : joins) {
            join = new MondrianModel.Join();
            Container leftContainer = sqlJoin.getLeftColumn().getContainer();
            MondrianModel.Join leftExistingJoin = null;
            if (tableToJoinMap.containsKey(leftContainer)) {
                MondrianModel.Join existingJoin;
                leftExistingJoin = existingJoin = (MondrianModel.Join)((Object)tableToJoinMap.get(leftContainer));
                join.setLeftAlias(leftContainer.getName());
                join.setLeft(existingJoin);
                join.setLeftKey(sqlJoin.getLeftColumn().getName());
                for (Map.Entry entry : tableToJoinMap.entrySet()) {
                    if (entry.getValue() != existingJoin) continue;
                    tableToJoinMap.put(leftContainer, join);
                }
            } else {
                MondrianModel.Table table = new MondrianModel.Table();
                table.setName(leftContainer.getName());
                join.setLeft(table);
                join.setLeftKey(sqlJoin.getLeftColumn().getName());
                tableToJoinMap.put(leftContainer, join);
            }
            Container rightContainer = sqlJoin.getRightColumn().getContainer();
            if (tableToJoinMap.containsKey(rightContainer)) {
                MondrianModel.Join existingJoin = (MondrianModel.Join)((Object)tableToJoinMap.get(rightContainer));
                join.setRightAlias(rightContainer.getName());
                join.setRight(existingJoin);
                join.setRightKey(sqlJoin.getRightColumn().getName());
                for (Map.Entry entry : tableToJoinMap.entrySet()) {
                    if (entry.getValue() != existingJoin) continue;
                    tableToJoinMap.put(rightContainer, join);
                }
                continue;
            }
            MondrianModel.Table table = new MondrianModel.Table();
            table.setName(rightContainer.getName());
            join.setRight(table);
            join.setRightKey(sqlJoin.getRightColumn().getName());
            tableToJoinMap.put(rightContainer, join);
        }
        if (join != null) {
            List<MondrianModel.Relation> list = this.getRelationList(join);
            for (int i = 0; i < list.size(); ++i) {
                MondrianModel.Relation relation = list.remove(i);
                if (list.indexOf((Object)relation) >= 0) {
                    String invalidJoinStatement = "<html>The join specified contains cycles and cannot be specified in OLAP.\nEither the cycle needs to be broken by dragging in the same table to duplicate it\nor a view can be created to represent this join specification.";
                    String invalidJoinDialogHeader = "Invalid join specification";
                    int retType = JOptionPane.showOptionDialog(this.panel, invalidJoinStatement, "Invalid join specification", 0, 2, null, new Object[]{"Create View", "Cancel"}, "Create View");
                    if (retType == 0) {
                        this.editPanel.setViewSelected();
                        this.editPanel.setSelectText(this.model.generateQuery());
                        return true;
                    }
                    return false;
                }
                list.add(i, relation);
            }
        }
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    private class compareByColumnCount
    implements Comparator<SQLJoin> {
        private compareByColumnCount() {
        }

        @Override
        public int compare(SQLJoin o1, SQLJoin o2) {
            int Join2ColCount;
            int join1ColCount = Math.max(o1.getLeftColumn().getParent().getItems().size(), o1.getRightColumn().getParent().getItems().size());
            if (join1ColCount < (Join2ColCount = Math.max(o2.getLeftColumn().getParent().getItems().size(), o2.getRightColumn().getParent().getItems().size()))) {
                return -1;
            }
            if (join1ColCount > Join2ColCount) {
                return 1;
            }
            return 0;
        }
    }
}

