/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.components.cipher;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.sonatype.plexus.components.cipher.Base64;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

public class PBECipher {
    protected static final String STRING_ENCODING = "UTF8";
    protected static final int SPICE_SIZE = 16;
    protected static final int SALT_SIZE = 8;
    protected static final int CHUNK_SIZE = 16;
    protected static final byte WIPER = 0;
    protected static final String DIGEST_ALG = "SHA-256";
    protected static final String KEY_ALG = "AES";
    protected static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";
    protected static final int PBE_ITERATIONS = 1000;
    private static final SecureRandom _secureRandom = new SecureRandom();

    private byte[] getSalt(int sz) {
        byte[] res2 = new byte[sz];
        _secureRandom.nextBytes(res2);
        return res2;
    }

    public String encrypt64(String clearText, String password) throws PlexusCipherException {
        try {
            byte[] clearBytes = clearText.getBytes(STRING_ENCODING);
            byte[] salt = this.getSalt(8);
            Cipher cipher = this.createCipher(password.getBytes(STRING_ENCODING), salt, 1);
            byte[] encryptedBytes = cipher.doFinal(clearBytes);
            int len = encryptedBytes.length;
            byte padLen = (byte)(16 - (8 + len + 1) % 16);
            int totalLen = 8 + len + padLen + 1;
            byte[] allEncryptedBytes = this.getSalt(totalLen);
            System.arraycopy(salt, 0, allEncryptedBytes, 0, 8);
            allEncryptedBytes[8] = padLen;
            System.arraycopy(encryptedBytes, 0, allEncryptedBytes, 9, len);
            byte[] encryptedTextBytes = Base64.encodeBase64(allEncryptedBytes);
            return new String(encryptedTextBytes, STRING_ENCODING);
        }
        catch (Exception e2) {
            throw new PlexusCipherException(e2);
        }
    }

    public String decrypt64(String encryptedText, String password) throws PlexusCipherException {
        try {
            byte[] allEncryptedBytes = Base64.decodeBase64(encryptedText.getBytes());
            int totalLen = allEncryptedBytes.length;
            byte[] salt = new byte[8];
            System.arraycopy(allEncryptedBytes, 0, salt, 0, 8);
            byte padLen = allEncryptedBytes[8];
            byte[] encryptedBytes = new byte[totalLen - 8 - 1 - padLen];
            System.arraycopy(allEncryptedBytes, 9, encryptedBytes, 0, encryptedBytes.length);
            Cipher cipher = this.createCipher(password.getBytes(STRING_ENCODING), salt, 2);
            byte[] clearBytes = cipher.doFinal(encryptedBytes);
            return new String(clearBytes, STRING_ENCODING);
        }
        catch (Exception e2) {
            throw new PlexusCipherException(e2);
        }
    }

    private Cipher createCipher(byte[] pwdAsBytes, byte[] salt, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        MessageDigest _digester = MessageDigest.getInstance(DIGEST_ALG);
        byte[] keyAndIv = new byte[32];
        if (salt == null || salt.length == 0) {
            salt = null;
        }
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            int stillNeed;
            byte[] result;
            _digester.update(pwdAsBytes);
            if (salt != null) {
                _digester.update(salt, 0, 8);
            }
            if ((result = _digester.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
            if ((currentPos += result.length) >= keyAndIv.length) continue;
            _digester.reset();
            _digester.update(result);
        }
        byte[] key2 = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(keyAndIv, 0, key2, 0, key2.length);
        System.arraycopy(keyAndIv, key2.length, iv, 0, iv.length);
        Cipher cipher = Cipher.getInstance(CIPHER_ALG);
        cipher.init(mode, (Key)new SecretKeySpec(key2, KEY_ALG), new IvParameterSpec(iv));
        return cipher;
    }
}

