/*
 * Decompiled with CFR 0.152.
 */
package javolution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;
import javolution.Javolution;
import javolution.JavolutionError;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import javolution.util.FastTable;

final class PerfUtil
extends Javolution
implements Runnable {
    private static final int MAX_COLLECTION_SIZE = 10000;
    private final Object[] _objects = new Object[10000];

    PerfUtil() {
    }

    public void run() throws JavolutionError {
        PerfUtil.println("//////////////////////////////");
        PerfUtil.println("// Package: javolution.util //");
        PerfUtil.println("//////////////////////////////");
        PerfUtil.println("");
        PerfUtil.println("(new)      : The collection is created (using the new keyword), populated, then discarded (throw-away collections).");
        PerfUtil.println("(recycled) : The collection is cleared, populated, then reused (static collections or throw-away collections in PoolContext).");
        PerfUtil.println("");
        for (int i = 0; i < 10000; ++i) {
            this._objects[i] = new Object();
        }
        PerfUtil.println("-- FastTable versus ArrayList -- ");
        PerfUtil.setOutputStream(null);
        this.benchmarkFastTable();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkFastTable();
        PerfUtil.setOutputStream(null);
        this.benchmarkArrayList();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkArrayList();
        PerfUtil.println("-- FastList versus LinkedList -- ");
        PerfUtil.setOutputStream(null);
        this.benchmarkFastList();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkFastList();
        PerfUtil.setOutputStream(null);
        this.benchmarkLinkedList();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkLinkedList();
        PerfUtil.println("");
        PerfUtil.println("-- FastMap versus HashMap  --");
        PerfUtil.setOutputStream(null);
        this.benchmarkFastMap();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkFastMap();
        PerfUtil.setOutputStream(null);
        this.benchmarkHashMap();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkHashMap();
        PerfUtil.setOutputStream(null);
        this.benchmarkLinkedHashMap();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkLinkedHashMap();
        PerfUtil.println("");
        PerfUtil.println("-- FastMap.setShared(true) versus ConcurrentHashMap  --");
        PerfUtil.setOutputStream(null);
        this.benchmarkSharedFastMap();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkSharedFastMap();
        PerfUtil.setOutputStream(null);
        this.benchmarkConcurrentHashMap();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkConcurrentHashMap();
        PerfUtil.println("");
        PerfUtil.println("-- FastSet versus HashSet --");
        PerfUtil.setOutputStream(null);
        this.benchmarkFastSet();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkFastSet();
        PerfUtil.setOutputStream(null);
        this.benchmarkHashSet();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkHashSet();
        PerfUtil.setOutputStream(null);
        this.benchmarkLinkedHashSet();
        PerfUtil.setOutputStream(System.out);
        this.benchmarkLinkedHashSet();
        PerfUtil.println("");
    }

    private void benchmarkFastTable() {
        FastTable<Object> fastTable = new FastTable<Object>();
        PerfUtil.println(fastTable.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", add (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastTable = new FastTable();
                n = 0;
                while (n < i) {
                    fastTable.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", add (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastTable.clear();
                n = 0;
                while (n < i) {
                    fastTable.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastTable.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastTable) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            if (fastTable instanceof RandomAccess) {
                PerfUtil.print(", get(int): ");
                PerfUtil.startTime();
                for (n2 = 0; n2 < n3 * 10; ++n2) {
                    int n4 = fastTable.size();
                    while (--n4 > 0) {
                        if (fastTable.get(n4) != fastTable) continue;
                        throw new Error();
                    }
                }
                PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            }
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkFastList() {
        FastList<Object> fastList = new FastList<Object>();
        PerfUtil.println(fastList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", add (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastList = new FastList();
                n = 0;
                while (n < i) {
                    fastList.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", add (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastList.clear();
                n = 0;
                while (n < i) {
                    fastList.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastList.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastList) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.print(", iteration (node): ");
            FastList<Object> fastList2 = fastList;
            PerfUtil.startTime();
            for (n = 0; n < n3 * 10; ++n) {
                FastCollection.Record record = fastList2.head();
                FastCollection.Record record2 = fastList2.tail();
                while ((record = ((FastList.Node)record).getNext()) != record2) {
                    if (((FastList.Node)record).getValue() != fastList) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            if (fastList instanceof RandomAccess) {
                PerfUtil.print(", get(int): ");
                PerfUtil.startTime();
                for (n = 0; n < n3 * 10; ++n) {
                    int n4 = fastList.size();
                    while (--n4 > 0) {
                        if (fastList.get(n4) != fastList) continue;
                        throw new Error();
                    }
                }
                PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            }
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkArrayList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!arrayList.getClass().getName().equals("java.util.ArrayList")) {
            return;
        }
        PerfUtil.println(arrayList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", add (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList = new ArrayList();
                n = 0;
                while (n < i) {
                    arrayList.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", add (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList.clear();
                n = 0;
                while (n < i) {
                    arrayList.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != arrayList) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            if (arrayList instanceof RandomAccess) {
                PerfUtil.print(", get(int): ");
                PerfUtil.startTime();
                for (n2 = 0; n2 < n3 * 10; ++n2) {
                    int n4 = arrayList.size();
                    while (--n4 > 0) {
                        if (arrayList.get(n4) != arrayList) continue;
                        throw new Error();
                    }
                }
                PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            }
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkLinkedList() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (!linkedList.getClass().getName().equals("java.util.LinkedList")) {
            return;
        }
        PerfUtil.println(linkedList.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", add (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedList = new LinkedList();
                n = 0;
                while (n < i) {
                    linkedList.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", add (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedList.clear();
                n = 0;
                while (n < i) {
                    linkedList.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != linkedList) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            if (linkedList instanceof RandomAccess) {
                PerfUtil.print(", get(int): ");
                PerfUtil.startTime();
                for (n2 = 0; n2 < n3 * 10; ++n2) {
                    int n4 = linkedList.size();
                    while (--n4 > 0) {
                        if (linkedList.get(n4) != linkedList) continue;
                        throw new Error();
                    }
                }
                PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            }
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkFastMap() {
        FastMap<Object, String> fastMap = new FastMap<Object, String>();
        PerfUtil.println(fastMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", put (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastMap = new FastMap();
                n = 0;
                while (n < i) {
                    fastMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", put (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastMap.clear();
                n = 0;
                while (n < i) {
                    fastMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", get: ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (fastMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastMap) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.print(", iteration (entry): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                FastCollection.Record record = fastMap.head();
                FastMap.Entry entry = fastMap.tail();
                while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                    if (((FastMap.Entry)record).getValue() != fastMap) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkHashMap() {
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        if (!hashMap.getClass().getName().equals("java.util.HashMap")) {
            return;
        }
        PerfUtil.println(hashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", put (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                hashMap = new HashMap();
                n = 0;
                while (n < i) {
                    hashMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", put (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                hashMap.clear();
                n = 0;
                while (n < i) {
                    hashMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", get: ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (hashMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != hashMap) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkSharedFastMap() {
        FastMap<Object, String> fastMap = new FastMap().setShared(true);
        PerfUtil.println("Shared FastMap");
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", put (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastMap = new FastMap().setShared(true);
                n = 0;
                while (n < i) {
                    fastMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", put (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastMap.clear();
                n = 0;
                while (n < i) {
                    fastMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", get: ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (fastMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastMap) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.print(", iteration (entry): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                FastCollection.Record record = fastMap.head();
                FastMap.Entry entry = fastMap.tail();
                while ((record = ((FastMap.Entry)record).getNext()) != entry) {
                    if (((FastMap.Entry)record).getValue() != fastMap) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkConcurrentHashMap() {
        ConcurrentHashMap<Object, String> concurrentHashMap = new ConcurrentHashMap<Object, String>();
        PerfUtil.println(concurrentHashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", put (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                concurrentHashMap = new ConcurrentHashMap();
                n = 0;
                while (n < i) {
                    concurrentHashMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", put (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                concurrentHashMap.clear();
                n = 0;
                while (n < i) {
                    concurrentHashMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", get: ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (concurrentHashMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = concurrentHashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != concurrentHashMap) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkLinkedHashMap() {
        LinkedHashMap<Object, String> linkedHashMap = new LinkedHashMap<Object, String>();
        if (!linkedHashMap.getClass().getName().equals("java.util.LinkedHashMap")) {
            return;
        }
        PerfUtil.println(linkedHashMap.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", put (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedHashMap = new LinkedHashMap();
                n = 0;
                while (n < i) {
                    linkedHashMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", put (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedHashMap.clear();
                n = 0;
                while (n < i) {
                    linkedHashMap.put(this._objects[n++], "");
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", get: ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (linkedHashMap.get(this._objects[n++]) == "") continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = linkedHashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != linkedHashMap) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkFastSet() {
        FastSet<Object> fastSet = new FastSet<Object>();
        PerfUtil.println(fastSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", add (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastSet = new FastSet();
                n = 0;
                while (n < i) {
                    fastSet.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", add (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                fastSet.clear();
                n = 0;
                while (n < i) {
                    fastSet.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", contain: ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (fastSet.contains(this._objects[n++])) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = fastSet.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != fastSet) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.print(", iteration (record): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                FastCollection.Record record = fastSet.head();
                FastCollection.Record record2 = fastSet.tail();
                while ((record = record.getNext()) != record2) {
                    if (fastSet.valueOf(record) != fastSet) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkHashSet() {
        HashSet<Object> hashSet = new HashSet<Object>();
        if (!hashSet.getClass().getName().equals("java.util.HashSet")) {
            return;
        }
        PerfUtil.println(hashSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", add (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                hashSet = new HashSet();
                n = 0;
                while (n < i) {
                    hashSet.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", add (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                hashSet.clear();
                n = 0;
                while (n < i) {
                    hashSet.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", contain: ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (hashSet.contains(this._objects[n++])) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != hashSet) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }

    private void benchmarkLinkedHashSet() {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        if (!linkedHashSet.getClass().getName().equals("java.util.LinkedHashSet")) {
            return;
        }
        PerfUtil.println(linkedHashSet.getClass());
        for (int i = 10; i <= 10000; i *= 10) {
            int n;
            int n2;
            int n3 = 1000000 / i;
            PerfUtil.print("    Size: " + i);
            PerfUtil.print(", add (new): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedHashSet = new LinkedHashSet();
                n = 0;
                while (n < i) {
                    linkedHashSet.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", add (recycled): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                linkedHashSet.clear();
                n = 0;
                while (n < i) {
                    linkedHashSet.add(this._objects[n++]);
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", contain: ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3; ++n2) {
                n = 0;
                while (n < i) {
                    if (linkedHashSet.contains(this._objects[n++])) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i));
            PerfUtil.print(", iteration (iterator): ");
            PerfUtil.startTime();
            for (n2 = 0; n2 < n3 * 10; ++n2) {
                Iterator iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != linkedHashSet) continue;
                    throw new Error();
                }
            }
            PerfUtil.print(PerfUtil.endTime(n3 * i * 10));
            PerfUtil.println("");
        }
        PerfUtil.println("");
    }
}

