/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.Font;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import net.java.plaf.Environment;
import net.java.plaf.LookAndFeelPatch;
import net.java.plaf.windows.NativeUtils;

public class WindowsFontPatch
implements LookAndFeelPatch {
    public boolean isApplicable(Environment env) {
        return env.isWindowsLookAndFeel();
    }

    public void patch(Environment env) {
        Object value;
        String dialogFont = NativeUtils.getShellDialogFont();
        String sysProp = System.getProperties().getProperty("swing.useSystemFontSettings");
        if ((sysProp == null || Boolean.valueOf(sysProp).booleanValue()) && ((value = UIManager.get("Application.useSystemFontSettings")) == null || Boolean.TRUE.equals(value))) {
            if (dialogFont == null) {
                String forceTahoma = System.getProperties().getProperty("winlaf.forceTahoma");
                if (Boolean.valueOf(forceTahoma).booleanValue()) {
                    System.err.println("WinLAF: winlaf.forceTahoma is no longer supported in 0.5. See the release notes.");
                }
                if (env.isWindows2000() || env.isWindowsXP() || env.isWindowsLonghorn()) {
                    this.patchFonts("Tahoma");
                }
            } else {
                this.patchFonts(dialogFont);
            }
        }
    }

    private void patchFonts(String fontName) {
        Font tfFont = UIManager.getDefaults().getFont("TextField.font");
        int tfSize = tfFont.getSize();
        this.patchFont("Button.font", fontName);
        this.patchFont("CheckBox.font", fontName);
        this.patchFont("ComboBox.font", fontName);
        this.patchFont("EditorPane.font", fontName);
        this.patchFont("FormattedTextField.font", fontName, tfSize);
        this.patchFont("Label.font", fontName);
        this.patchFont("List.font", fontName);
        this.patchFont("RadioButton.font", fontName);
        this.patchFont("Panel.font", fontName);
        this.patchFont("PasswordField.font", fontName, tfSize + 1);
        this.patchFont("ProgressBar.font", fontName);
        this.patchFont("ScrollPane.font", fontName);
        this.patchFont("Spinner.font", fontName);
        this.patchFont("TabbedPane.font", fontName);
        this.patchFont("Table.font", fontName);
        this.patchFont("TableHeader.font", fontName);
        this.patchFont("TextArea.font", fontName, tfSize);
        this.patchFont("TextField.font", fontName);
        this.patchFont("TextPane.font", fontName);
        this.patchFont("TitledBorder.font", fontName);
        this.patchFont("ToggleButton.font", fontName);
        this.patchFont("Tree.font", fontName);
        this.patchFont("Viewport.font", fontName);
    }

    private void patchFont(String uiResource, String fontName) {
        Font originalFont = UIManager.getFont(uiResource);
        FontUIResource newFont = new FontUIResource(fontName, originalFont.getStyle(), originalFont.getSize());
        UIManager.put(uiResource, newFont);
    }

    private void patchFont(String uiResource, String fontName, int fontSize) {
        Font originalFont = UIManager.getFont(uiResource);
        FontUIResource newFont = new FontUIResource(fontName, originalFont.getStyle(), fontSize);
        UIManager.put(uiResource, newFont);
    }

    public void unpatch() {
    }
}

