/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.map;

import com.googlecode.d2j.map.InheritanceTree;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class ProguardMappingParser {
    private String j2d(String type) {
        StringBuilder sb = new StringBuilder();
        while (type.endsWith("[]")) {
            sb.append("[");
            type = type.substring(0, type.length() - 2);
        }
        switch (type) {
            case "boolean": {
                sb.append("Z");
                break;
            }
            case "byte": {
                sb.append("B");
                break;
            }
            case "short": {
                sb.append("S");
                break;
            }
            case "char": {
                sb.append("C");
                break;
            }
            case "int": {
                sb.append("I");
                break;
            }
            case "float": {
                sb.append("F");
                break;
            }
            case "long": {
                sb.append("J");
                break;
            }
            case "double": {
                sb.append("D");
                break;
            }
            case "void": {
                sb.append("V");
                break;
            }
            default: {
                sb.append("L").append(type.replace('.', '/')).append(";");
            }
        }
        return sb.toString();
    }

    public void parse(Reader in, InheritanceTree tree) throws IOException {
        BufferedReader r = new BufferedReader(in);
        String currentClz = null;
        String ln = r.readLine();
        while (ln != null) {
            String[] as;
            if (ln.startsWith(" ")) {
                ln = ln.trim();
                as = ln.split(" ");
                String fieldDescOrMethodRet = this.j2d(as[0]);
                String fieldNameOrMethodNameDesc = as[1];
                String newName = as[3];
                if (fieldNameOrMethodNameDesc.contains("(")) {
                    String[] ps;
                    int idx = fieldNameOrMethodNameDesc.indexOf(40);
                    String mName = fieldNameOrMethodNameDesc.substring(0, idx);
                    String args = fieldNameOrMethodNameDesc.substring(idx + 1, fieldNameOrMethodNameDesc.length() - 1);
                    if (args.length() != 0) {
                        ps = args.split(",");
                        int i = 0;
                        while (i < ps.length) {
                            ps[i] = this.j2d(ps[i]);
                            ++i;
                        }
                    } else {
                        ps = new String[]{};
                    }
                    tree.recordMethodRenameTo(currentClz, mName, ps, fieldDescOrMethodRet, newName);
                } else {
                    tree.recordFieldRenameTo(currentClz, fieldNameOrMethodNameDesc, fieldDescOrMethodRet, newName);
                }
            } else {
                as = ln.split(" ");
                currentClz = this.j2d(as[0]);
                String newName = as[2];
                if (newName.endsWith(":")) {
                    newName = newName.substring(0, newName.length() - 1);
                }
                tree.recordClassRenameTo(currentClz, this.j2d(newName));
            }
            ln = r.readLine();
        }
    }
}

