/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.gen;

import com.android.dx.gen.Type;
import com.android.dx.gen.TypeList;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.type.Prototype;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodId<D, R> {
    final Type<D> declaringType;
    final Type<R> returnType;
    final String name;
    final TypeList parameters;
    final CstNat nat;
    final CstMethodRef constant;

    MethodId(Type<D> declaringType, Type<R> returnType, String name, TypeList parameters) {
        if (declaringType == null || returnType == null || name == null || parameters == null) {
            throw new NullPointerException();
        }
        this.declaringType = declaringType;
        this.returnType = returnType;
        this.name = name;
        this.parameters = parameters;
        this.nat = new CstNat(new CstString(name), new CstString(this.descriptor(false)));
        this.constant = new CstMethodRef(declaringType.constant, this.nat);
    }

    public Type<D> getDeclaringType() {
        return this.declaringType;
    }

    public Type<R> getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public List<Type<?>> getParameters() {
        return this.parameters.asList();
    }

    String descriptor(boolean includeThis) {
        StringBuilder result = new StringBuilder();
        result.append("(");
        if (includeThis) {
            result.append(this.declaringType.name);
        }
        for (Type<?> t : this.parameters.types) {
            result.append(t.name);
        }
        result.append(")");
        result.append(this.returnType.name);
        return result.toString();
    }

    Prototype prototype(boolean includeThis) {
        return Prototype.intern(this.descriptor(includeThis));
    }

    public boolean equals(Object o) {
        return o instanceof MethodId && ((MethodId)o).declaringType.equals(this.declaringType) && ((MethodId)o).name.equals(this.name) && ((MethodId)o).parameters.equals(this.parameters) && ((MethodId)o).returnType.equals(this.returnType);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.declaringType.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.returnType.hashCode();
        return result;
    }

    public String toString() {
        return this.declaringType + "." + this.name + "(" + this.parameters + ")";
    }
}

