/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.extensions.soap;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class SOAPFaultSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public static final long serialVersionUID = 1L;

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPFault sOAPFault = (SOAPFault)extensibilityElement;
        if (sOAPFault != null) {
            String string = DOMUtils.getQualifiedValue("http://schemas.xmlsoap.org/wsdl/soap/", "fault", definition);
            printWriter.print("        <" + string);
            DOMUtils.printAttribute("name", sOAPFault.getName(), printWriter);
            DOMUtils.printAttribute("use", sOAPFault.getUse(), printWriter);
            DOMUtils.printAttribute("encodingStyle", StringUtils.getNMTokens(sOAPFault.getEncodingStyles()), printWriter);
            DOMUtils.printAttribute("namespace", sOAPFault.getNamespaceURI(), printWriter);
            Boolean bl = sOAPFault.getRequired();
            if (bl != null) {
                DOMUtils.printQualifiedAttribute(Constants.Q_ATTR_REQUIRED, bl.toString(), definition, printWriter);
            }
            printWriter.println("/>");
        }
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        SOAPFault sOAPFault = (SOAPFault)extensionRegistry.createExtension(clazz, qName);
        QName qName2 = DOMUtils.getQualifiedAttributeValue(element, "message", "header", false, definition);
        String string = DOMUtils.getAttribute(element, "name");
        String string2 = DOMUtils.getAttribute(element, "use");
        String string3 = DOMUtils.getAttribute(element, "encodingStyle");
        String string4 = DOMUtils.getAttribute(element, "namespace");
        String string5 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/wsdl/", "required");
        if (string != null) {
            sOAPFault.setName(string);
        }
        if (string2 != null) {
            sOAPFault.setUse(string2);
        }
        if (string3 != null) {
            sOAPFault.setEncodingStyles(StringUtils.parseNMTokens(string3));
        }
        if (string4 != null) {
            sOAPFault.setNamespaceURI(string4);
        }
        if (string5 != null) {
            sOAPFault.setRequired(new Boolean(string5));
        }
        return sOAPFault;
    }
}

