/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;

public class StackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;
    public static final StackTraceElementDeserializer instance = new StackTraceElementDeserializer();

    public StackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            String className = "";
            String methodName = "";
            String fileName = "";
            int lineNumber = -1;
            while ((t = jp.nextValue()) != JsonToken.END_OBJECT) {
                String propName = jp.getCurrentName();
                if ("className".equals(propName)) {
                    className = jp.getText();
                    continue;
                }
                if ("fileName".equals(propName)) {
                    fileName = jp.getText();
                    continue;
                }
                if ("lineNumber".equals(propName)) {
                    if (t.isNumeric()) {
                        lineNumber = jp.getIntValue();
                        continue;
                    }
                    throw JsonMappingException.from(jp, "Non-numeric token (" + t + ") for property 'lineNumber'");
                }
                if ("methodName".equals(propName)) {
                    methodName = jp.getText();
                    continue;
                }
                if ("nativeMethod".equals(propName)) continue;
                this.handleUnknownProperty(jp, ctxt, this._valueClass, propName);
            }
            return new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        throw ctxt.mappingException(this._valueClass, t);
    }
}

