/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.catalog.query;

import org.xmlresolver.CatalogManager;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryCatalog;
import org.xmlresolver.catalog.entry.EntryNotation;
import org.xmlresolver.catalog.query.QueryCatalog;
import org.xmlresolver.catalog.query.QueryPublic;
import org.xmlresolver.catalog.query.QueryResult;
import org.xmlresolver.utils.PublicId;

public class QueryNotation
extends QueryCatalog {
    public final String notationName;
    public final String systemId;
    public final String publicId;

    public QueryNotation(String notationName, String systemId, String publicId) {
        this.notationName = notationName;
        this.systemId = systemId;
        this.publicId = publicId == null ? null : PublicId.normalize(publicId);
    }

    @Override
    protected QueryResult lookup(CatalogManager manager, EntryCatalog catalog) {
        QueryPublic queryPublic = new QueryPublic(this.systemId, this.publicId);
        QueryResult result = queryPublic.lookup(manager, catalog);
        if (result.resolved()) {
            return result;
        }
        for (Entry raw : catalog.entries(Entry.Type.NOTATION)) {
            EntryNotation entry = (EntryNotation)raw;
            if (!entry.name.equals(this.notationName)) continue;
            return new QueryResult(entry.uri);
        }
        return QueryResult.EMPTY_RESULT;
    }
}

