/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupMatchingIterator;
import net.sf.saxon.functions.Count;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class GroupEndingIterator
extends GroupMatchingIterator
implements GroupIterator,
LookaheadIterator {
    public GroupEndingIterator(Expression select, Pattern endPattern, XPathContext context) throws XPathException {
        this.select = select;
        this.pattern = endPattern;
        this.baseContext = context;
        this.runningContext = context.newMinorContext();
        this.population = this.runningContext.trackFocus(select.iterate(context));
        this.nextItem = this.population.next();
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        try {
            GroupEndingIterator another = new GroupEndingIterator(this.select, this.pattern, this.baseContext);
            return Count.steppingCount(another);
        }
        catch (XPathException e) {
            throw new UncheckedXPathException(e);
        }
    }

    @Override
    protected void advance() throws XPathException {
        this.currentMembers = new ArrayList(20);
        this.currentMembers.add(this.current);
        this.nextItem = this.current;
        while (this.nextItem != null) {
            if (this.pattern.matches(this.nextItem, this.runningContext)) {
                this.nextItem = this.population.next();
                if (this.nextItem == null) continue;
                break;
            }
            this.nextItem = this.population.next();
            if (this.nextItem == null) continue;
            this.currentMembers.add(this.nextItem);
        }
    }
}

