/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.overlay;

import com.google.common.base.Preconditions;
import io.mola.galimatias.URL;
import java.util.HashMap;
import java.util.Map;

public final class OverlayTextChecker {
    private final Map<URL, String> docToOverlayMap = new HashMap<URL, String>();

    public boolean registerOverlay(URL contentDocURL, String overlayID) {
        Preconditions.checkArgument((contentDocURL != null ? 1 : 0) != 0);
        Preconditions.checkArgument((overlayID != null ? 1 : 0) != 0);
        if (!this.docToOverlayMap.containsKey(contentDocURL)) {
            this.docToOverlayMap.put(contentDocURL, overlayID);
            return true;
        }
        return overlayID.equals(this.docToOverlayMap.get(contentDocURL));
    }

    public boolean isReferencedByOverlay(URL contentDocURL) {
        if (contentDocURL == null) {
            return false;
        }
        return this.docToOverlayMap.containsKey(contentDocURL);
    }

    public boolean isCorrectOverlay(URL contentDocURL, String overlayID) {
        return overlayID.equals(this.docToOverlayMap.get(contentDocURL));
    }
}

