/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ssl.conf;

import com.google.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.naming.ldap.LdapName;
import javax.ws.rs.core.UriBuilder;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ssl.conf.LdapNameGuacamoleProperty;
import org.apache.guacamole.auth.ssl.conf.WildcardURIGuacamoleProperty;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.IntegerGuacamoleProperty;
import org.apache.guacamole.properties.StringGuacamoleProperty;
import org.apache.guacamole.properties.URIGuacamoleProperty;

public class ConfigurationService {
    private static String DEFAULT_CLIENT_CERTIFICATE_HEADER = "X-Client-Certificate";
    private static String DEFAULT_CLIENT_VERIFIED_HEADER = "X-Client-Verified";
    private static int DEFAULT_MAX_TOKEN_VALIDITY = 5;
    private static int DEFAULT_MAX_DOMAIN_VALIDITY = 5;
    private static final WildcardURIGuacamoleProperty SSL_AUTH_URI = new WildcardURIGuacamoleProperty(){

        public String getName() {
            return "ssl-auth-uri";
        }
    };
    private static final URIGuacamoleProperty SSL_AUTH_PRIMARY_URI = new URIGuacamoleProperty(){

        public String getName() {
            return "ssl-auth-primary-uri";
        }
    };
    private static final StringGuacamoleProperty SSL_AUTH_CLIENT_CERTIFICATE_HEADER = new StringGuacamoleProperty(){

        public String getName() {
            return "ssl-auth-client-certificate-header";
        }
    };
    private static final StringGuacamoleProperty SSL_AUTH_CLIENT_VERIFIED_HEADER = new StringGuacamoleProperty(){

        public String getName() {
            return "ssl-auth-client-verified-header";
        }
    };
    private static final IntegerGuacamoleProperty SSL_AUTH_MAX_TOKEN_VALIDITY = new IntegerGuacamoleProperty(){

        public String getName() {
            return "ssl-auth-max-token-validity";
        }
    };
    private static final StringGuacamoleProperty SSL_AUTH_SUBJECT_USERNAME_ATTRIBUTE = new StringGuacamoleProperty(){

        public String getName() {
            return "ssl-auth-subject-username-attribute";
        }
    };
    private static final LdapNameGuacamoleProperty SSL_AUTH_SUBJECT_BASE_DN = new LdapNameGuacamoleProperty(){

        public String getName() {
            return "ssl-auth-subject-base-dn";
        }
    };
    private static final IntegerGuacamoleProperty SSL_AUTH_MAX_DOMAIN_VALIDITY = new IntegerGuacamoleProperty(){

        public String getName() {
            return "ssl-auth-max-domain-validity";
        }
    };
    @Inject
    private Environment environment;

    private boolean hostnameMatches(String hostname, int offset, URI uri) {
        String expectedHostname;
        int endOfHostname = hostname.indexOf(58);
        if (endOfHostname == -1) {
            endOfHostname = hostname.length();
        }
        if ((expectedHostname = uri.getHost()).length() != endOfHostname - offset) {
            return false;
        }
        return hostname.regionMatches(true, offset, expectedHostname, 0, expectedHostname.length());
    }

    public URI getClientAuthenticationURI(String subdomain) throws GuacamoleException {
        URI authURI = (URI)this.environment.getRequiredProperty((GuacamoleProperty)SSL_AUTH_URI);
        String baseHostname = authURI.getHost();
        return UriBuilder.fromUri((URI)authURI).host(subdomain + "." + baseHostname).build(new Object[0]);
    }

    public String getClientAuthenticationSubdomain(String hostname) throws GuacamoleException {
        if (this.isPrimaryHostname(hostname)) {
            return null;
        }
        int firstPeriod = hostname.indexOf(46);
        if (firstPeriod <= 0) {
            return null;
        }
        URI authURI = (URI)this.environment.getRequiredProperty((GuacamoleProperty)SSL_AUTH_URI);
        if (!this.hostnameMatches(hostname, firstPeriod + 1, authURI)) {
            return null;
        }
        return hostname.substring(0, firstPeriod);
    }

    public URI getPrimaryURI() throws GuacamoleException {
        return (URI)this.environment.getRequiredProperty((GuacamoleProperty)SSL_AUTH_PRIMARY_URI);
    }

    public URI getPrimaryOrigin() throws GuacamoleException {
        URI primaryURI = this.getPrimaryURI();
        try {
            return new URI(primaryURI.getScheme(), null, primaryURI.getHost(), primaryURI.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new GuacamoleServerException("Request origin could not be derived from the configured primary URI.", (Throwable)e);
        }
    }

    public boolean isPrimaryHostname(String hostname) throws GuacamoleException {
        URI primaryURI = this.getPrimaryURI();
        return this.hostnameMatches(hostname, 0, primaryURI);
    }

    public String getClientCertificateHeader() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)SSL_AUTH_CLIENT_CERTIFICATE_HEADER, (Object)DEFAULT_CLIENT_CERTIFICATE_HEADER);
    }

    public String getClientVerifiedHeader() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)SSL_AUTH_CLIENT_VERIFIED_HEADER, (Object)DEFAULT_CLIENT_VERIFIED_HEADER);
    }

    public int getMaxTokenValidity() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)SSL_AUTH_MAX_TOKEN_VALIDITY, (Object)DEFAULT_MAX_TOKEN_VALIDITY);
    }

    public int getMaxDomainValidity() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)SSL_AUTH_MAX_DOMAIN_VALIDITY, (Object)DEFAULT_MAX_DOMAIN_VALIDITY);
    }

    public LdapName getSubjectBaseDN() throws GuacamoleException {
        return (LdapName)this.environment.getProperty((GuacamoleProperty)SSL_AUTH_SUBJECT_BASE_DN);
    }

    public Collection<String> getSubjectUsernameAttributes() throws GuacamoleException {
        return this.environment.getPropertyCollection((GuacamoleProperty)SSL_AUTH_SUBJECT_USERNAME_ATTRIBUTE);
    }
}

