/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ssl.conf;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.properties.URIGuacamoleProperty;

public abstract class WildcardURIGuacamoleProperty
extends URIGuacamoleProperty {
    private static final Pattern WILDCARD_URI_PATTERN = Pattern.compile("([^:]+://(?:[^@]+@)?)\\*\\.(.*)");

    public URI parseValue(String value) throws GuacamoleException {
        URI uri;
        if (value == null) {
            return null;
        }
        Matcher matcher = WILDCARD_URI_PATTERN.matcher(value);
        if (matcher.matches() && (uri = super.parseValue(matcher.group(1) + matcher.group(2))).getHost() != null) {
            return uri;
        }
        throw new GuacamoleServerException("Value \"" + value + "\" is not a valid wildcard URI.");
    }
}

