/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.Rectangle;
import java.io.IOException;

public class RectangleTypeAdapter {
    private static final TypeAdapter<Rectangle> SINGLETON = new TypeAdapter<Rectangle>(){

        public void write(JsonWriter out, Rectangle value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.beginObject();
                out.name("x").value(value.getX());
                out.name("y").value(value.getY());
                out.name("width").value(value.getWidth());
                out.name("height").value(value.getHeight());
                out.endObject();
            }
        }

        public Rectangle read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            Rectangle rectangle = new Rectangle();
            block12: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "x": {
                        rectangle.x = in.nextInt();
                        continue block12;
                    }
                    case "y": {
                        rectangle.y = in.nextInt();
                        continue block12;
                    }
                    case "width": {
                        rectangle.width = in.nextInt();
                        continue block12;
                    }
                    case "height": {
                        rectangle.height = in.nextInt();
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unknown field in Rectangle: " + name);
            }
            in.endObject();
            return rectangle;
        }
    };

    public static TypeAdapter<Rectangle> singleton() {
        return SINGLETON;
    }

    private RectangleTypeAdapter() {
    }
}

