/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.HiddenApiRestriction;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.util.AnnotatedBytes;

public class HiddenApiClassDataItem {
    public static final int SIZE_OFFSET = 0;
    public static final int OFFSETS_LIST_OFFSET = 4;
    public static final int OFFSET_ITEM_SIZE = 4;

    @Nonnull
    public static SectionAnnotator makeAnnotator(@Nonnull DexAnnotator annotator, @Nonnull MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            @Nonnull
            public String getItemName() {
                return "hiddenapi_class_data_item";
            }

            @Override
            protected void annotateItem(@Nonnull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                int startOffset = out.getCursor();
                out.annotate(4, "size = 0x%x", this.dexFile.getDataBuffer().readSmallUint(out.getCursor()));
                int index = 0;
                for (ClassDef classDef : this.dexFile.getClasses()) {
                    out.annotate(0, "[%d] %s", index, classDef);
                    out.indent();
                    int offset = this.dexFile.getDataBuffer().readSmallUint(out.getCursor());
                    if (offset == 0) {
                        out.annotate(4, "offset = 0x%x", offset);
                    } else {
                        out.annotate(4, "offset = 0x%x (absolute offset: 0x%x)", offset, startOffset + offset);
                    }
                    int nextOffset = out.getCursor();
                    if (offset > 0) {
                        int restrictions;
                        out.deindent();
                        out.moveTo(startOffset + offset);
                        DexReader<? extends DexBuffer> reader = this.dexFile.getBuffer().readerAt(out.getCursor());
                        for (Field field : classDef.getStaticFields()) {
                            out.annotate(0, "%s:", field);
                            out.indent();
                            restrictions = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "restriction = 0x%x: %s", restrictions, HiddenApiRestriction.formatHiddenRestrictions(restrictions));
                            out.deindent();
                        }
                        for (Field field : classDef.getInstanceFields()) {
                            out.annotate(0, "%s:", field);
                            out.indent();
                            restrictions = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "restriction = 0x%x: %s", restrictions, HiddenApiRestriction.formatHiddenRestrictions(restrictions));
                            out.deindent();
                        }
                        for (Method method : classDef.getDirectMethods()) {
                            out.annotate(0, "%s:", method);
                            out.indent();
                            restrictions = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "restriction = 0x%x: %s", restrictions, HiddenApiRestriction.formatHiddenRestrictions(restrictions));
                            out.deindent();
                        }
                        for (Method method : classDef.getVirtualMethods()) {
                            out.annotate(0, "%s:", method);
                            out.indent();
                            restrictions = reader.readSmallUleb128();
                            out.annotateTo(reader.getOffset(), "restriction = 0x%x: %s", restrictions, HiddenApiRestriction.formatHiddenRestrictions(restrictions));
                            out.deindent();
                        }
                        out.indent();
                    }
                    out.moveTo(nextOffset);
                    out.deindent();
                    ++index;
                }
            }
        };
    }
}

