/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.ice4j.Transport;
import org.ice4j.ice.AgentConfig;
import org.ice4j.ice.NetworkUtils;

public class TransportAddress
extends InetSocketAddress {
    private static final long serialVersionUID = 5076001401234631237L;
    private final Transport transport;

    public TransportAddress(String hostname, int port2, Transport transport) {
        super(hostname, port2);
        this.transport = transport;
    }

    public TransportAddress(byte[] ipAddress, int port2, Transport transport) throws UnknownHostException {
        this(InetAddress.getByAddress(ipAddress), port2, transport);
    }

    public TransportAddress(InetSocketAddress address, Transport transport) {
        this(address.getAddress(), address.getPort(), transport);
    }

    public TransportAddress(InetAddress address, int port2, Transport transport) {
        super(address, port2);
        this.transport = transport;
    }

    public byte[] getAddressBytes() {
        return this.getAddress().getAddress();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toRedactedString() {
        return this.toString(true);
    }

    private String toString(boolean redact) {
        String hostAddress;
        if (redact) {
            String hostName;
            hostAddress = this.getRedactedAddress();
            if (hostAddress == null && (hostName = this.getHostName()) != null) {
                hostAddress = "xxxx.xxx";
            }
        } else {
            hostAddress = this.getHostAddress();
            if (hostAddress == null) {
                hostAddress = this.getHostName();
            }
        }
        if (hostAddress == null) {
            hostAddress = "null";
        }
        StringBuilder bldr = new StringBuilder(hostAddress);
        if (this.isIPv6()) {
            bldr.insert(0, "[").append("]");
        }
        bldr.append(":").append(this.getPort());
        bldr.append("/").append((Object)this.getTransport());
        return bldr.toString();
    }

    public String getHostAddress() {
        String addressStr;
        InetAddress addr = this.getAddress();
        String string = addressStr = addr != null ? addr.getHostAddress() : null;
        if (addr instanceof Inet6Address) {
            addressStr = NetworkUtils.stripScopeID(addressStr);
        }
        return addressStr;
    }

    public String getRedactedAddress() {
        if (AgentConfig.config.getRedactRemoteAddresses()) {
            InetAddress addr = this.getAddress();
            if (addr != null) {
                return TransportAddress.toRedactedString(addr);
            }
            return null;
        }
        return this.getHostAddress();
    }

    public Transport getTransport() {
        return this.transport;
    }

    public boolean equals(TransportAddress transportAddress) {
        return this.equalsTransportAddress(transportAddress);
    }

    public boolean equalsTransportAddress(Object obj) {
        return super.equals(obj) && ((TransportAddress)obj).getTransport() == this.getTransport();
    }

    public boolean isIPv6() {
        return this.getAddress() instanceof Inet6Address;
    }

    public boolean canReach(TransportAddress dst) {
        if (this.getTransport() != dst.getTransport()) {
            return false;
        }
        if (this.isIPv6() != dst.isIPv6()) {
            return false;
        }
        if (this.isIPv6()) {
            Inet6Address srcAddr = (Inet6Address)this.getAddress();
            Inet6Address dstAddr = (Inet6Address)dst.getAddress();
            if (srcAddr.isLinkLocalAddress() != dstAddr.isLinkLocalAddress()) {
                return Boolean.getBoolean("org.ice4j.ALLOW_LINK_TO_GLOBAL_REACHABILITY");
            }
        }
        return true;
    }

    public static String redact(InetAddress addr) {
        if (AgentConfig.config.getRedactRemoteAddresses()) {
            return TransportAddress.toRedactedString(addr);
        }
        return addr.getHostAddress();
    }

    public static String redact(SocketAddress addr) {
        if (addr instanceof InetSocketAddress && AgentConfig.config.getRedactRemoteAddresses()) {
            InetSocketAddress iaddr = (InetSocketAddress)addr;
            return TransportAddress.toRedactedString(iaddr.getAddress()) + ":" + iaddr.getPort();
        }
        if (addr == null) {
            return null;
        }
        return addr.toString();
    }

    public static String toRedactedString(InetAddress addr) {
        if (addr == null) {
            return null;
        }
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return addr.getHostAddress();
        }
        if (addr instanceof Inet6Address) {
            StringBuilder sb = new StringBuilder();
            byte[] addrBytes = addr.getAddress();
            if ((addrBytes[0] & 0xE0) == 32) {
                sb.append("2xxx");
            } else if (addrBytes[0] != 0 || addrBytes[1] != 0) {
                sb.append(Integer.toHexString(addrBytes[0] << 8 & 0xFF00 | addrBytes[1] & 0xFF));
            }
            sb.append("::xxx");
            return sb.toString();
        }
        if (addr instanceof Inet4Address) {
            return "xx.xx.xx.xx";
        }
        return addr.getHostAddress();
    }
}

